using System.Collections.Generic;
using Verse;
using RimWorld;
using LudeonTK;

namespace rjw
{

	
	public class HediffComp_GrowsWithOwner : HediffComp
	{
		public float lastOwnerSize = -1;

		private const int UpdateInterval = GenTicks.TickRareInterval;

		public static bool ForceUpdate = false;
		public void UpdatePartSize(HediffComp_SexPart partComp)
		{
			//get ~relative size variable from calculation()
			var relativeSize = partComp.baseSize;

			//remove old lifestage bodysize mod
			relativeSize /= partComp.originalOwnerSize;

			//add new lifestage bodysize mod
			relativeSize *= Pawn.BodySize;

			//save new size
			partComp.baseSize = relativeSize;

			//update owner size
			partComp.originalOwnerSize = Pawn.BodySize;

			// update/reset part size
			partComp.UpdateSeverity();
		}
		public HediffCompProperties_GrowsWithOwner Props => (HediffCompProperties_GrowsWithOwner)props;

		public override void CompPostTickInterval(ref float severityAdjustment, int delta)
		{
			// natural parts make sense to grow relative to the owner.
			// transplanted or bionic parts will appear to shrink (relatively) when a pawn grows in size.

			// this comp keeps part severity (relative size) FIXED by updating the baseSize when bodySize changes.			
			// parts having extra growth/shrinkage with lifeStage (puberty) is handled by lifeStageFactor, not this.

			// Only update at interval to improve performance
			if (!ForceUpdate && !Pawn.IsHashIntervalTick(UpdateInterval, delta))
				return;
			ForceUpdate = false;

			// Skip if body size hasn't changed since last check
			if (Pawn.BodySize == lastOwnerSize) return;

			// Attempt to get the sex part component
			if (!parent.TryGetComp<HediffComp_SexPart>(out var partComp))
			{
				Log.WarningOnce($"HediffComp_SexPart missing on {parent.def.defName}", parent.def.GetHashCode() + 450720);
				return;
			}

			//no changes for transplants
			if (partComp.isTransplant && !Props.evenIfTransplanted) return;
			UpdatePartSize(partComp);
			lastOwnerSize = Pawn.BodySize;
		}

		public override void CompExposeData()
		{
			base.CompExposeData();
			Scribe_Values.Look(ref lastOwnerSize, "lastOwnerSize");
		}
	}
}