using Verse;
using RimWorld;
using Multiplayer.API;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;

using ShowParts = rjw.RJWSettings.ShowParts;
using System.Text;
using System;

namespace rjw
{
	/// <summary>
	/// Comp for rjw hediff parts
	/// </summary>
	public class HediffComp_SexPart : HediffCompDesc
	{
		public string SizeLabel => parent.CurStage?.label ?? "";

		public string originalOwnerRace = "";      //base race when part created
		public string previousOwner = "";            //base race when part created

		private float? forcedSize;
		public float baseSize;                              	// Absolute base size when part created, someday alter by operation
		public float originalOwnerSize = 0;                         // Body size of this part's first owner. Not used in calculations.
		public bool isTransplant = false;                   //transplanted from someone else

		// Whether this part could ever have been seen by the player based on mod settings and apparel.
		public bool discovered;

		private bool initialised;

		public new HediffDef_SexPart Def => (HediffDef_SexPart)base.Def;

		public HediffCompProperties_SexPart Props => (HediffCompProperties_SexPart)props;


		public float partFluidMultiplier = -1;            // Multiplier on Milk/Ejaculation/Wetness
		private SexFluidDef fluidOverride;           // Cummies/milk - insectjelly/honey etc
		public float FluidAmount => GetFluidAmount();
		public float FluidMultiplier => GetFluidMultiplier();
		public SexFluidDef Fluid
		{
			get => fluidOverride ?? Def.fluid;
			set {
				if (value == Def.fluid)
				{
					fluidOverride = null;
				}
				else
				{
					fluidOverride = value;
				}
			}
		}
		public float GetFluidMultiplier()
		{
			return Def.GetFluidMultiplier(GetSeverity(), partFluidMultiplier, GetBodySize(), SexUtility.ScaleToHumanAge(Pawn));
		}

		public float GetFluidAmount()
		{
			return Def.GetFluidAmount(GetFluidMultiplier());
		}

		
		private List<string> DefaultPositionNames
		{
			get
			{
				List<string> result = Def.defaultBodyPartList ?? new();
				string singleDefaultPart = Def.defaultBodyPart;
				if (!singleDefaultPart.NullOrEmpty() && !result.Contains(singleDefaultPart))
				{
					result.Add(singleDefaultPart);
				}
				return result;
			}
		}

		public float Size
		{
			get => GetSize();
		}


		// makes parts appear to grow with pawn (aka puberty)
		public bool HasForcedSize => forcedSize.HasValue;
		public float GetSize() {
			if (forcedSize.HasValue)
			{
				return forcedSize.Value;
			}
			return baseSize;
		}
		public float GetSeverity()
		{
			// Severity = baseSize * LifeStageFactor / Pawn.BodySize;
			return GetSize() / Pawn.BodySize;
		}
		public void SetSeverity(float newSeverity, bool sync = true)
		{
			if(!forcedSize.HasValue)
			{
				baseSize = newSeverity * Pawn.BodySize;
			}
			if (sync)
			{
				SyncSeverity();
			}
		}

		public void SyncSeverity()
		{
			parent.Severity = GetSeverity();
		}
		public void UpdateSeverity(float newSeverity = -1f)
		{
			if(newSeverity < 0)
			{
				SyncSeverity();
			}
			else
			{
				SetSeverity(newSeverity);
			}
		}
		public void ForceSize(float size)
		{
			forcedSize = size;
			UpdateSeverity();
		}
		public void UnforceSize()
		{
			forcedSize = null;
			UpdateSeverity();
		}
		public float GetBodySize()
		{
			return Pawn.BodySize;
		}

		/// <summary>
		/// save data
		/// </summary>
		public override void CompExposeData()
		{
			base.CompExposeData();

			Scribe_Values.Look(ref baseSize, nameof(baseSize));
			Scribe_Values.Look(ref originalOwnerSize, nameof(originalOwnerSize));
			Scribe_Values.Look(ref originalOwnerRace, nameof(originalOwnerRace));
			Scribe_Values.Look(ref previousOwner, nameof(previousOwner));
			Scribe_Defs.Look(ref fluidOverride, nameof(fluidOverride));
			Scribe_Values.Look(ref partFluidMultiplier, nameof(partFluidMultiplier), defaultValue: Def.GetRandomPartFluidMultiplier());
			Scribe_Values.Look(ref isTransplant, nameof(isTransplant));
			Scribe_Values.Look(ref forcedSize, nameof(forcedSize));
			Scribe_Values.Look(ref discovered, nameof(discovered));
			Scribe_Values.Look(ref initialised, nameof(initialised), defaultValue: true);
		}

		public override void CompPostPostAdd(DamageInfo? dinfo)
		{
			base.CompPostPostAdd(dinfo);
			try//error at world gen
			{
				Pawn.GetRJWPawnData().genitals = new List<Hediff>();
				Pawn.GetRJWPawnData().breasts = new List<Hediff>();
				Pawn.GetRJWPawnData().anus = new List<Hediff>();
			}
			catch
			{
			}
			if (!initialised)
			{
				//Log.Message("CompPostPostAdd");
				Init(reroll: false);
			}
		}

		// can be used instead of SexPartAdder::PartMaker, RacePartDef_Helper::PartMaker
		//public override void CompPostMake()
		//{
		//	base.CompPostMake();
		//	// A null pawn is only possible in vanilla in verb-related debug outputs, but better safe than sorry.
		//	if (Pawn != null)	
		//	{
		//		if (!initialised)
		//		{
		//			Log.Message("CompPostMake");
		//			Init();
		//		}
		//	}
		//}

		public override void CompPostPostRemoved()
		{
			base.CompPostPostRemoved();
			try
			{
				Pawn.GetRJWPawnData().genitals = new List<Hediff>();
				Pawn.GetRJWPawnData().breasts = new List<Hediff>();
				Pawn.GetRJWPawnData().anus = new List<Hediff>();
			}
			catch
			{
			}
		}

		public override bool CompDisallowVisible()
		{
			if (base.CompDisallowVisible())
			{
				return true;
			}

			if (RJWSettings.ShowRjwParts == ShowParts.Hide)
			{
				return true;
			}

			if (discovered)
			{
				return false;
			}

			// Show if required by settings, or at game start if in dev mode
			if (RJWSettings.ShowRjwParts != ShowParts.Known || (Current.ProgramState != ProgramState.Playing && Prefs.DevMode))
			{
				discovered = true;
				return false;
			}

			// Show for hero and apparel-less pawns
			if (Pawn.IsDesignatedHero() && Pawn.IsHeroOwner() || Pawn.apparel == null)
			{
				discovered = true;
			}
			else
			{
				var partGroups = parent.Part.groups;
				if (!partGroups.Any(group => Pawn.apparel.BodyPartGroupIsCovered(group)))
				{
					discovered = true;
				}
			}
			return !discovered;
		}

		private static readonly StringBuilder sb = new();

		/// <summary>
		/// show part info in healthtab
		/// </summary>
		public override string CompTipStringExtra
		{
			get
			{
				if (!initialised)
				{
					ModLog.Warning(" " + xxx.get_pawnname(Pawn) + " part " + parent.def.defName + " is broken, resetting");
					Init();
					UpdateSeverity();
					updatepartposition();
				}
				// In theory the tip should be a condensed form and the longer form should be elsewhere, but where?
				sb.Clear();
				IEnumerable<string> tipLines = GetTipString(RJWSettings.ShowRjwParts == RJWSettings.ShowParts.Extended);
				foreach(string line in tipLines)
				{
					sb.AppendLine(line);
				}
				return sb.ToString();
			}
		}

		public IEnumerable<string> GetTipString(bool extended)
		{
			//ModLog.Message(" CompTipStringExtra " + xxx.get_pawnname(Pawn) + " " + parent.def.defName);
			// TODO: Part type should be a property in the extension.
			//StringBuilder defstringBuilder = new StringBuilder();
			if (parent.Part != null)
			{
				if (Def.genitalFamily == GenitalFamily.Breasts)
				{
					return GetBreastTip(extended);
				}
				else if (Def.genitalFamily == GenitalFamily.Penis)
				{
					return GetPenisTip(extended);
				}
				else if (Def.genitalFamily == GenitalFamily.Anus || Def.genitalFamily == GenitalFamily.Vagina)
				{
					return GetOrificeTip(extended);
				}
				else if (Def.genitalFamily == GenitalFamily.FemaleOvipositor || Def.genitalFamily == GenitalFamily.MaleOvipositor)
				{
					return GetEggTip();
				}
			}

			return Enumerable.Empty<string>();
		}

		private string _eggTip = null;
		IEnumerable<string> GetEggTip()
		{
			if (Def.genitalTags.Contains(GenitalTag.CanEgg))
			{
				if (_eggTip == null)
				{
					var possibleEggNames = HediffComp_Ovipositor.PossibleEggs(Pawn.kindDef?.defName)
						.SelectMany(eggDef => eggDef.childrenDefs)
						.Select(defName => DefDatabase<PawnKindDef>.GetNamedSilentFail(defName)?.LabelCap.ToString())
						.Where(label => label != null)
						.Distinct().ToList();

					_eggTip = possibleEggNames.ToCommaList();
				}
				yield return "RJW_PartInfo_eggs".Translate(_eggTip);
			}
		}

		IEnumerable<string> GetPenisTip(bool extended)
		{
			if (PartSizeCalculator.TryGetLength(parent, out float length))
			{
				yield return "RJW_PartInfo_length".Translate(length.ToString("F1"));
			}

			if (!extended)
			{
				yield break;
			}

			if (PartSizeCalculator.TryGetGirth(parent, out float girth))
			{
				yield return "RJW_PartInfo_girth".Translate(girth.ToString("F1"));
			}

			if (PartSizeCalculator.TryGetPenisWeight(parent, out float weight))
			{
				yield return "RJW_PartInfo_weight".Translate(weight.ToString("F1"));
			}

			foreach (var line in GetFluidTip())
			{
				yield return line;
			}

			foreach (var line in GetPropertiesTip())
			{
				yield return line;
			}
		}

		IEnumerable<string> GetOrificeTip(bool extended)
		{
			if (!extended)
			{
				yield break;
			}
			//defstringBuilder.Append(this.Def.description);
			//defstringBuilder.AppendLine("Cum: " + FluidType);
			//defstringBuilder.AppendLine("Ejaculation: " + (FluidAmmount * FluidModifier).ToString("F2") + "ml");

			// TODO: Should be scaled bigger than penis size either in xml or here.
			if (PartSizeCalculator.TryGetLength(parent, out float length))
			{
				yield return "RJW_PartInfo_maxLength".Translate(length.ToString("F1"));
			}

			if (PartSizeCalculator.TryGetGirth(parent, out float girth))
			{
				yield return "RJW_PartInfo_maxGirth".Translate(girth.ToString("F1"));
			}

			foreach (var line in GetFluidTip())
			{
				yield return line;
			}

			foreach (var line in GetPropertiesTip())
			{
				yield return line;
			}
		}

		IEnumerable<string> GetBreastTip(bool extended)
		{
			if(!extended)
			{
				foreach (var line in GetBraCupTip())
				{
					yield return line;
				}
				yield break;
			}

			if (PartSizeCalculator.TryGetBreastSize(parent, out BreastSize breastSize))
			{
				yield return "RJW_PartInfo_braSize".Translate(breastSize.GetBandSize(), breastSize.GetCupSize());
				yield return "RJW_PartInfo_weight".Translate(breastSize.weight.ToString("F3"));
			}

			foreach (var line in GetFluidTip())
			{
				yield return line;
			}

			foreach (var line in GetPropertiesTip())
			{
				yield return line;
			}
		}

		IEnumerable<string> GetBraCupTip()
		{
			if(GetSeverity() >= 0.02f)
			{
				if (PartSizeCalculator.TryGetBreastSize(parent, out BreastSize breastSize))
				{
					yield return "RJW_PartInfo_braCup".Translate(breastSize.GetCupSize());
				}
			}
		}

		IEnumerable<string> GetFluidTip()
		{
			if (FluidAmount != 0 && Fluid != null)
			{
				yield return "RJW_PartInfo_fluidTypeFluidAmount".Translate(
					Fluid.LabelCap,
					FluidAmount.ToString("F1"));
			}

			if (RJWSettings.DevMode)
			{
				yield return "RJW_PartInfo_fluidMultiplier".Translate($"{FluidMultiplier:F3} ({partFluidMultiplier:F3})");
			}
		}

		IEnumerable<string> GetPropertiesTip()
		{
			var showTransplant = isTransplant && parent is Hediff_NaturalSexPart;
			if (Def.partTags.Any() || showTransplant)
			{
				var tags = new List<string>();
				Def.partTags.ForEach(tag => tags.Add(("PartsTag_"+tag).Translate()));
				var tagList = tags.ToCommaList();
				if(showTransplant)
				{
					tagList = Def.partTags.Prepend("Transplant").ToCommaList();
				}
				yield return "RJW_PartInfo_properties".Translate(tagList);
			}
		}

		[SyncMethod]
		public void updatepartposition()
		{
			if (parent.def is not HediffDef_SexPart def)
			{
				return;
			}

			//Log.Message("0 " + (parent.Part == null));
			//Log.Message("1 " +parent.Part);
			//Log.Message("2 " +parent.Part.def);
			//Log.Message("3 " +parent.Part.def.defName);
			//Log.Message("4 " +partBase);
			//Log.Message("5 " +partBase.DefaultBodyPart);
			//ModLog.Message("pawn " + xxx.get_pawnname(Pawn) + ", part: " + parent.def.defName);
			if (parent.Part == null)
			{
				var bp = Pawn.RaceProps.body.AllParts.Find(x => DefaultPositionNames.Any(x.def.defName.Contains));
				if (bp != null)
				{
					ModLog.Warning(" " + xxx.get_pawnname(Pawn) + " part is null/wholebody? is in wrong BodyPart position, resetting to default: " + def.defaultBodyPart);
					parent.Part = bp;
					Pawn.GetRJWPawnData().genitals = new List<Hediff>();
					Pawn.GetRJWPawnData().breasts = new List<Hediff>();
					Pawn.GetRJWPawnData().anus = new List<Hediff>();
				}
				else
				{
					ModLog.Message(" " + xxx.get_pawnname(Pawn) + " default bodypart not found: " + def.defaultBodyPart + " -skip.");
				}
			}
			else if (def.defaultBodyPart != "" && !parent.Part.def.defName.Contains(def.defaultBodyPart))
			{
				//Log.Message("f");
				//Log.Message(partBase.DefaultBodyPartList.ToLineList());
				if (def.defaultBodyPartList.Any() && def.defaultBodyPartList.Any(parent.Part.def.defName.Contains))
				{
					return;
				}
				var bp = Pawn.RaceProps.body.AllParts.Find(x => x.def.defName.Contains(def.defaultBodyPart));
				if (bp != null)
				{
					ModLog.Warning(" " + xxx.get_pawnname(Pawn) + " part " + parent.def.defName + " is in wrong BodyPart position, resetting to default: " + def.defaultBodyPart);
					parent.Part = bp;
					Pawn.GetRJWPawnData().genitals = new List<Hediff>();
					Pawn.GetRJWPawnData().breasts = new List<Hediff>();
					Pawn.GetRJWPawnData().anus = new List<Hediff>();
				}
				else
				{
					ModLog.Message(" " + xxx.get_pawnname(Pawn) + " default bodypart not found: " + def.defaultBodyPart + " -skip.");
				}
				//if (pawn.IsColonist)
				//{
				//	Log.Message(xxx.get_pawnname(pawn) + " has broken hediffs, removing " + this.ToString());
				//	Log.Message(Part.ToString());
				//	Log.Message(bp.def.defName);
				//	Log.Message(partBase.DefaultBodyPart.ToString());
				//}
			}
		}

		/// <summary>
		/// fill comp data
		/// </summary>
		[SyncMethod]
		public void Init(Pawn pawn = null, bool reroll = true)
		{
			pawn ??= Pawn;

			if (originalOwnerSize == 0)
			{
				originalOwnerSize = pawn.BodySize;
			}

			if (reroll || baseSize == 0)
			{
				//var s = (parent is Hediff_NaturalSexPart) ? originalOwnerSize : Pawn.RaceProps.baseBodySize;
				baseSize = CalculateSize(pawn, originalOwnerSize);
			}

			if(reroll || partFluidMultiplier == -1)
			{
				partFluidMultiplier = Def.GetRandomPartFluidMultiplier();
			}

			if (originalOwnerRace.NullOrEmpty())
			{
				originalOwnerRace = pawn?.kindDef.race.LabelCap ?? "RJW_PartInfo_unknownSpecies".Translate();
			}
			previousOwner = pawn?.LabelNoCount ?? "RJW_PartInfo_unknownOwner".Translate();

			//Log.Message("1 "+originalOwnerSize);
			//Log.Message("2 " + baseSize);
			UpdateSeverity();
			//Log.Message("3 " + baseSize);
			initialised = true;
		}

		[SyncMethod]
		public float CalculateSize(Pawn pawn, float bodySize)
		{
			float relativeSize;
			if (Def.genitalFamily == GenitalFamily.Breasts && pawn?.gender == Gender.Male && !Rand.Chance(TrapChance(pawn)))
			{
				relativeSize = .01f;
			}
			else
			{
				relativeSize = Def.GetRandomSize();
			}
			return relativeSize * bodySize;
		}

		private static float TrapChance(Pawn pawn)
		{
			if (RJWSettings.MaleTrap && !xxx.is_animal(pawn))
			{
				if (xxx.is_nympho(pawn))
				{
					return RJWSettings.futa_nymph_chance;
				}
				if (pawn.Faction != null && (int)pawn.Faction.def.techLevel < 5)
				{
					return RJWSettings.futa_natives_chance;
				}
				return RJWSettings.futa_spacers_chance;
			}
			return 0f;
		}



		public override IEnumerable<StatDrawEntry> SpecialDisplayStats(StatRequest req)
		{

			// Chosen semi-arbitrarily. Change these if stat ordering seems janky.
			int statOrder = 5000;
			var genitalStatsCat = RJWStatCategoryDefOf.GenitalStats;
			var ownerCategory = RJWStatCategoryDefOf.OriginalPartOwner;

			if (parent.Part != null)
			{
				if (Def.genitalFamily == GenitalFamily.Breasts)
				{
					yield return new StatDrawEntry(genitalStatsCat, "RJW_PartInfo_T_Title".Translate(), "RJW_PartInfo_T_Breast".Translate(), "", statOrder--);

					if (PartSizeCalculator.TryGetBreastSize(parent, out BreastSize breastSize))
					{
						yield return new StatDrawEntry(genitalStatsCat, "RJW_StatEntry_PartCupSize".Translate(), $"{breastSize.GetBandSize()} - {breastSize.GetCupSize()}","", statOrder--);
						yield return new StatDrawEntry(genitalStatsCat, "RJW_StatEntry_PartWeight".Translate(), breastSize.weight.ToString("F3"), "", statOrder--);
					}

				}
				else if (Def.genitalFamily == GenitalFamily.Penis)
				{
					yield return new StatDrawEntry(genitalStatsCat, "RJW_PartInfo_T_Title".Translate(), "RJW_PartInfo_T_Penis".Translate(), "", statOrder--);
					if (PartSizeCalculator.TryGetLength(parent, out float penisLength))
					{
						yield return new StatDrawEntry(genitalStatsCat, "RJW_StatEntry_PartLength".Translate(), penisLength.ToString("F1"), "", statOrder--);
					}

					if (PartSizeCalculator.TryGetGirth(parent, out float girth))
					{
						yield return new StatDrawEntry(genitalStatsCat, "RJW_StatEntry_PartGirth".Translate(), girth.ToString("F1"), "", statOrder--);
						//yield return "RJW_PartInfo_girth".Translate(girth.ToString("F1"));
					}

					if (PartSizeCalculator.TryGetPenisWeight(parent, out float weight))
					{
						yield return new StatDrawEntry(genitalStatsCat, "RJW_StatEntry_PartWeight".Translate(), weight.ToString("F1"), "", statOrder--);
						//yield return "RJW_PartInfo_weight".Translate(weight.ToString("F1"));
					}
				}
				else if (Def.genitalFamily == GenitalFamily.Anus)
				{
					yield return new StatDrawEntry(genitalStatsCat, "RJW_PartInfo_T_Title".Translate(), "RJW_PartInfo_T_Anus".Translate(), "", statOrder--);
					if (PartSizeCalculator.TryGetLength(parent, out float length))
					{
						yield return new StatDrawEntry(genitalStatsCat, "RJW_StatEntry_PartDepth".Translate(), length.ToString("F1"), "", statOrder--);
					}

					if (PartSizeCalculator.TryGetGirth(parent, out float girth))
					{

						yield return new StatDrawEntry(genitalStatsCat, "RJW_StatEntry_PartGirth".Translate(), girth.ToString("F1"), "", statOrder--);
					}
				}
				else if (Def.genitalFamily == GenitalFamily.Vagina)
				{
					yield return new StatDrawEntry(genitalStatsCat, "RJW_PartInfo_T_Title".Translate(), "RJW_PartInfo_T_Vagina".Translate(), "", statOrder--);
					if (PartSizeCalculator.TryGetLength(parent, out float length))
					{
						yield return new StatDrawEntry(genitalStatsCat, "RJW_StatEntry_PartDepth".Translate(), length.ToString("F1"), "", statOrder--);
					}

					if (PartSizeCalculator.TryGetGirth(parent, out float girth))
					{

						yield return new StatDrawEntry(genitalStatsCat, "RJW_StatEntry_PartGirth".Translate(), girth.ToString("F1"), "", statOrder--);
					}
				}
				else if (Def.genitalFamily == GenitalFamily.FemaleOvipositor || Def.genitalFamily == GenitalFamily.MaleOvipositor)
				{
					yield return new StatDrawEntry(genitalStatsCat, "RJW_PartInfo_T_Title".Translate(), "RJW_PartInfo_T_Ovipositor".Translate(), "", statOrder--);
					if (Def.genitalTags.Contains(GenitalTag.CanEgg))
					{
						var possibleEggNames = HediffComp_Ovipositor.PossibleEggs(Pawn.kindDef?.defName)
							.SelectMany(eggDef => eggDef.childrenDefs)
							.Select(defName => DefDatabase<PawnKindDef>.GetNamedSilentFail(defName)?.LabelCap.ToString())
							.Where(label => label != null)
							.Distinct().ToList();

						yield return new StatDrawEntry(genitalStatsCat, "RJW_PartInfo_EggTypes".Translate(), possibleEggNames.ToCommaList(), "", statOrder--);
					}
				}
			}

			/*
			if (PartSizeCalculator.TryGetLength(parent, out float length))
			{
				yield return new StatDrawEntry(genitalStatsCat, "RJW_StatEntry_PartSize".Translate(), length.ToString("F1"), "", statOrder--);
			}*/

			if (Fluid != null)
			{
				yield return new StatDrawEntry(genitalStatsCat, "RJW_StatEntry_Fluid".Translate(), Fluid.LabelCap, "", statOrder--);
			}

			if (Fluid != null && FluidAmount != 0)
			{
				string fluidAmountKey = Def.genitalFamily switch
				{
					GenitalFamily.Penis or GenitalFamily.MaleOvipositor => "RJW_StatEntry_FluidAmount_ejaculation",
					GenitalFamily.Vagina or GenitalFamily.Anus => "RJW_StatEntry_FluidAmount_wetness",
					_ => "RJW_StatEntry_FluidAmount"
				};

				yield return new StatDrawEntry(genitalStatsCat, fluidAmountKey.Translate(), FluidAmount.ToString("F2"), "", statOrder--);
			}

			

			if (!Def.partTags.NullOrEmpty())
			{
				var tags = Def.partTags;
				yield return new StatDrawEntry(genitalStatsCat, "RJW_StatEntry_PartTags".Translate(), tags.ToCommaList(), "", statOrder--);
			} else
			{
				yield return new StatDrawEntry(genitalStatsCat, "RJW_StatEntry_PartTags".Translate(),"None", "", statOrder--);
			}

			// Ownership info
			if (!previousOwner.NullOrEmpty())
			{
				yield return new StatDrawEntry(ownerCategory, "RJW_StatEntry_PreviousOwner".Translate(), previousOwner, "", 1);
			}
			if (!originalOwnerRace.NullOrEmpty())
			{
				yield return new StatDrawEntry(ownerCategory, "RJW_StatEntry_OriginalOwnerRace".Translate(), originalOwnerRace, "", 2);
			}
		}
		
	}
}
