﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using RimWorld;
using Verse;

namespace rjw
{
	/// <summary>
	/// This Derived Class simply implements a version of the `SpecialDisplayStats` method that will check to see if any of the 
	/// attached Comps have a similar upgraded derived class, and Append their information to the Hediff's Info Card (The Little `i` Icon.).
	/// </summary>
	public class HediffWithCompDesc : HediffWithComps
	{
		
		/// <summary>
		/// Function to provide data to the Hediff's Info card, Suggest you replicate the first three lines in your own code if Overriding.
		/// </summary>
		/// <param name="req"></param>
		/// <returns></returns>
		public override IEnumerable<StatDrawEntry> SpecialDisplayStats(StatRequest req)
		{
			foreach (StatDrawEntry statDrawEntry in base.SpecialDisplayStats(req))
			{
				yield return statDrawEntry;
			}

			//Iterate over all the Comps provided by the Hediff, and if they're Description derived, check them for Stat Lines.
			if (this.comps != null)
			{
				foreach (HediffComp curComp in this.comps)
				{
					//HediffCompDesc tmp = new HediffCompDesc() ;
					if (curComp.GetType().IsSubclassOf(typeof(HediffCompDesc)))
					{
						HediffCompDesc tmp = (HediffCompDesc)curComp;
						foreach (StatDrawEntry statDrawEntry in tmp.SpecialDisplayStats(req))
						{
							yield return statDrawEntry;
						}
					}
				}
			}

			yield break;
		}
	}
}
