namespace rjw.Modules.Attraction
{
	/// <summary>
	/// The major attraction factors.
	/// </summary>
	public enum AttractionMode
	{
		/// <summary>
		/// This considers how one pawn views another's age.
		/// </summary>
		Age,
		/// <summary>
		/// This considers how one pawn views another's body.  It may also consider
		/// things that affect a pawn, like drugs, horniness, or fertility.
		/// </summary>
		Physical,
		/// <summary>
		/// This considers things like orientation, romantic partners, and other
		/// things influencing feelings of love.
		/// </summary>
		Romantic,
		/// <summary>
		/// This considers things like opinion, societal roles, and RJW's designations.
		/// </summary>
		Social
	}
}