namespace rjw.Modules.Attraction
{
	/// <summary>
	/// How the observer considers their relations in the context of the target.
	/// </summary>
	public enum AttractionStatus
	{
		/// <summary>
		/// <para>The pawn has no spouse.</para>
		/// <para>There may still be other ideological factors that might make the
		/// pawn wish to avoid a hookup, however.</para>
		/// </summary>
		Open,
		/// <summary>
		/// The target of the request is a spouse of the pawn.
		/// </summary>
		Marital,
		/// <summary>
		/// The pawn has at least one spouse and the target is not one of them.
		/// </summary>
		Extramarital
	}
}