using Verse;

namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// Handles an animal observing a human-like pawn.  The more pettness they
	/// have, the more they'll be into humans.
	/// </summary>
	public sealed class P_AnimalToHuman : AttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// Only for animal to human requests.
			if (request.Category is not AttractionCategory.AnimalToHuman) return;
			// Target must specifically be humanlike (and not a robot/mechanoid).
			if (!request.Target.IsHumanLike()) return;

			request.SetPreference(new P_AnimalToHuman());
		}

		private P_AnimalToHuman() : base(
			AttractionMode.Physical,
			nameof(P_AnimalToHuman),
			FactorOperation.Add)
		{ }

		protected override float GetOperand(ref AttractionRequest request, float factor) =>
			GenMath.LerpDouble(0f, 1f, -0.25f, 0.25f, request.Pawn.RaceProps.petness);
	}
}