namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// <para>Applies a bonus for an animal observing its own species.</para>
	/// <para>This is basically the equivilent of `P_HumanToBodyType`, but
	/// for animals.</para>
	/// </summary>
	public sealed class P_AnimalToSameSpecies : PredicatedAttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// Request must be between animals.
			if (request.Category is not AttractionCategory.BetweenAnimals) return;

			request.SetPreference(new P_AnimalToSameSpecies());
		}

		private P_AnimalToSameSpecies() : base(
			AttractionMode.Physical,
			nameof(P_AnimalToSameSpecies),
			FactorOperation.Add,
			IsSameSpecies,
			whenTrue: FixedValue(0.25f))
		{ }

		private static bool IsSameSpecies(ref AttractionRequest request) =>
			request.Target.IsSameSpecies(request.Pawn);
	}
}