namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// <para>Handles the penalty applied for disfigurement.</para>
	/// <para>The teratophile quirk will turn this into a bonus.</para>
	/// </summary>
	public sealed class P_Disfigurement : PredicatedAttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request) =>
			request.SetPreference(new P_Disfigurement());

		private P_Disfigurement() : base(
			AttractionMode.Physical,
			nameof(P_Disfigurement),
			FactorOperation.Multiply,
			IsDisfigured,
			whenTrue: FixedValue(0.8f))
		{ }

		private static bool IsDisfigured(ref AttractionRequest request) =>
			request.Target.IsDisfiguredTo(request.Pawn);
	}
}