namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// Handles the observer's non-romantic relations, which are used to suppress
	/// incestuous encounters.
	/// </summary>
	public sealed class R_IncestAversion : AttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request) =>
			request.SetPreference(new R_IncestAversion());

		private R_IncestAversion() : base(
			AttractionMode.Romantic,
			nameof(R_IncestAversion),
			FactorOperation.Multiply)
		{ }

		protected override float GetOperand(ref AttractionRequest request, float factor)
		{
			var operand = 1f;

			// The `romanceChanceFactor` is specifically to depress incest.  The
			// `RelationsUtility.Incestuous` method checks for `romanceChanceFactor != 1f`,
			// so even if it's a boost, vanilla RimWorld counts it as incest, so I'm not
			// gonna bother with checks against boosting values. Animals are included here
			// because RJW adds animal pregnancy and therefore familial relations.
			foreach (var relDef in request.Relations)
				operand *= relDef.romanceChanceFactor;
			return operand;
		}
	}
}