namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// <para>Handles a rapist's desire to get back at someone.</para>
	/// <para>"For the people of this colony, I promise...  REVENGE!"</para>
	/// </summary>
	public sealed class R_RevengeRape : PredicatedAttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// Must be for rape.
			if (!request.Purpose.IsForRape()) return;
			// Not applicable between animals...  Yet.
			if (request.Category.InvolvesAnimals()) return;

			request.SetPreference(new R_RevengeRape());
		}

		private R_RevengeRape() : base(
			AttractionMode.Romantic,
			nameof(R_RevengeRape),
			FactorOperation.Add,
			AttractionUtility.CanHaveRevengeRape,
			whenTrue: FixedValue(0.2f))
		{ }
	}
}