namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// Handles hostility between pawns.
	/// </summary>
	public sealed class S_Hostility : PredicatedAttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request) =>
			request.SetPreference(new S_Hostility());

		private S_Hostility() : base(
			AttractionMode.Social,
			nameof(S_Hostility),
			FactorOperation.Add,
			AttractionUtility.HasHostility,
			whenTrue: WithHostility,
			whenFalse: WithoutHostility)
		{ }

		private static float WithHostility(ref AttractionRequest request, float factor) =>
			request.Purpose.IsForRape() ? 0.2f : -0.4f;
		
		private static float WithoutHostility(ref AttractionRequest request, float factor)
		{
			// Animals don't care about other non-hostile animals.
			if (request.Category.AnimalObserver()) return 0f;
			return request.Purpose.IsForRape() ? -0.2f : 0.1f;
		}
	}
}