namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// Applies a bonus for a non-service human pawn toward service pawns.
	/// </summary>
	public sealed class S_HumanToServicer : FlatAttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// Only applicable for sex.
			if (request.Purpose.IsNotForSex()) return;
			// Cannot involve animals.
			if (request.Category.InvolvesAnimals()) return;
			// And the observer cannot be for service.
			if (request.Pawn.IsDesignatedService()) return;
			// And the target must be for service.
			if (!request.Target.IsDesignatedService()) return;

			request.SetPreference(new S_HumanToServicer());
		}

		private S_HumanToServicer() : base(
			AttractionMode.Social,
			nameof(S_HumanToServicer),
			FactorOperation.Add,
			0.2f)
		{ }
	}
}