using Verse;

namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// Handles ideologies between two pawns.
	/// </summary>
	public sealed class S_Ideology : PredicatedAttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// Requires ideology.
			if (!ModsConfig.IdeologyActive) return;
			// Observer must have an ideology.
			if (request.Pawn.Ideo is null) return;
			// Animals can't have an ideology, so don't bother.
			if (request.Category.AnimalTarget()) return;

			request.SetPreference(new S_Ideology());
		}

		private S_Ideology() : base(
			AttractionMode.Social,
			nameof(S_Ideology),
			FactorOperation.Add,
			HasDifferingIdeo,
			whenTrue: WithDifferingIdeo,
			whenFalse: WithSameIdeo)
		{ }

		private static bool HasDifferingIdeo(ref AttractionRequest request)
		{
			// Should not happen, but if something adds this preference
			// incorrectly, handle it by treating them as different by default.
			if (request.Pawn.Ideo is not { } pIdeo) return true;
			if (request.Target.Ideo is not { } tIdeo) return true;
			return pIdeo != tIdeo;
		}

		private static float WithDifferingIdeo(ref AttractionRequest request, float factor)
		{
			// Rapists like to pound sense into heathens.
			if (request.Purpose.IsForRape()) return 0.2f;
			
			// Unless raping, pawns don't generally care about different ideos.
			// TODO: Unless their ideology suggests otherwise, I guess.
			return 0f;
		}
		
		// Bias rapists toward raping pawns of other factions.
		private static float WithSameIdeo(ref AttractionRequest request, float factor)
		{
			// Rapists are a little friendlier to similar thinking pawns.
			if (request.Purpose.IsForRape()) return -0.1f;

			// Pawns are attracted to similar thinking pawns.
			return 0.1f;
		}
	}
}