namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// Applies a bonus for a service human pawn toward non-service pawns.
	/// </summary>
	public sealed class S_ServicerBias : FlatAttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// Only applicable for sex.
			if (request.Purpose.IsNotForSex()) return;
			// Cannot involve animals (which don't have money).
			if (request.Category.InvolvesAnimals()) return;
			// And the observer must be for service.
			if (!request.Pawn.IsDesignatedService()) return;
			// And the target must not be for service.
			if (request.Target.IsDesignatedService()) return;
			// Must have differing factions.
			if (request.Pawn.Faction == request.Target.Faction) return;

			request.SetPreference(new S_ServicerBias());
		}

		private S_ServicerBias() : base(
			AttractionMode.Social,
			nameof(S_ServicerBias),
			FactorOperation.Add,
			0.2f)
		{ }
	}
}