using RimWorld;
using Verse;
using Verse.AI;

namespace rjw
{
	/// <summary>
	/// Called to determine if the animal can mate(vanilla reproductory sex) with animals.
	/// </summary>
	public class ThinkNode_ConditionalMate : ThinkNode_Conditional
	{
		protected override bool Satisfied(Pawn p)
		{
			if (xxx.is_animal(p) && RJWSettings.animal_on_animal_enabled)
			{
				if (!RJWSettings.wild_mating_enabled && p.Faction != Faction.OfPlayer)
				{
					return false;
				}
				return true;
			}
			return false;
		}
	}
}
