package bep.hax.util;

import net.minecraft.item.Item;
import net.minecraft.item.Items;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;

public class StonecutterUtil {
    // https://minecraft.wiki/w/Stonecutter#Usage
    public static final Reference2ReferenceOpenHashMap<Item, ReferenceSet<Item>> STONECUTTER_BLOCKS = new Reference2ReferenceOpenHashMap<>();

    static {
        STONECUTTER_BLOCKS.put(
            Items.STONE,
            ReferenceSet.of(
                Items.STONE_STAIRS,
                Items.STONE_SLAB,
                Items.STONE_BRICKS,
                Items.STONE_BRICK_STAIRS,
                Items.STONE_BRICK_SLAB,
                Items.STONE_BRICK_WALL,
                Items.CHISELED_STONE_BRICKS
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.COBBLESTONE,
            ReferenceSet.of(
                Items.COBBLESTONE_STAIRS,
                Items.COBBLESTONE_SLAB,
                Items.COBBLESTONE_WALL
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.MOSSY_COBBLESTONE,
            ReferenceSet.of(
                Items.MOSSY_COBBLESTONE_STAIRS,
                Items.MOSSY_COBBLESTONE_SLAB,
                Items.MOSSY_COBBLESTONE_WALL
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.SMOOTH_STONE,
            ReferenceSet.of(
                Items.SMOOTH_STONE_SLAB
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.STONE_BRICKS,
            ReferenceSet.of(
                Items.STONE_BRICK_STAIRS,
                Items.STONE_BRICK_SLAB,
                Items.STONE_BRICK_WALL,
                Items.CHISELED_STONE_BRICKS
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.MOSSY_STONE_BRICKS,
            ReferenceSet.of(
                Items.MOSSY_STONE_BRICK_STAIRS,
                Items.MOSSY_STONE_BRICK_SLAB,
                Items.MOSSY_STONE_BRICK_WALL
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.GRANITE,
            ReferenceSet.of(
                Items.GRANITE_STAIRS,
                Items.GRANITE_SLAB,
                Items.GRANITE_WALL,
                Items.POLISHED_GRANITE,
                Items.POLISHED_GRANITE_STAIRS,
                Items.POLISHED_GRANITE_SLAB
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.POLISHED_GRANITE,
            ReferenceSet.of(
                Items.POLISHED_GRANITE_STAIRS,
                Items.POLISHED_GRANITE_SLAB
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.DIORITE,
            ReferenceSet.of(
                Items.DIORITE_STAIRS,
                Items.DIORITE_SLAB,
                Items.DIORITE_WALL,
                Items.POLISHED_DIORITE,
                Items.POLISHED_DIORITE_STAIRS,
                Items.POLISHED_DIORITE_SLAB
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.POLISHED_DIORITE,
            ReferenceSet.of(
                Items.POLISHED_DIORITE_STAIRS,
                Items.POLISHED_DIORITE_SLAB
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.ANDESITE,
            ReferenceSet.of(
                Items.ANDESITE_STAIRS,
                Items.ANDESITE_SLAB,
                Items.ANDESITE_WALL,
                Items.POLISHED_ANDESITE,
                Items.POLISHED_ANDESITE_STAIRS,
                Items.POLISHED_ANDESITE_SLAB
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.POLISHED_ANDESITE,
            ReferenceSet.of(
                Items.POLISHED_ANDESITE_STAIRS,
                Items.POLISHED_ANDESITE_SLAB
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.COBBLED_DEEPSLATE,
            ReferenceSet.of(
                Items.COBBLED_DEEPSLATE_STAIRS,
                Items.COBBLED_DEEPSLATE_SLAB,
                Items.COBBLED_DEEPSLATE_WALL,
                Items.CHISELED_DEEPSLATE,
                Items.POLISHED_DEEPSLATE,
                Items.POLISHED_DEEPSLATE_STAIRS,
                Items.POLISHED_DEEPSLATE_SLAB,
                Items.POLISHED_DEEPSLATE_WALL,
                Items.DEEPSLATE_BRICKS,
                Items.DEEPSLATE_BRICK_SLAB,
                Items.DEEPSLATE_BRICK_STAIRS,
                Items.DEEPSLATE_BRICK_WALL,
                Items.DEEPSLATE_TILES,
                Items.DEEPSLATE_TILE_SLAB,
                Items.DEEPSLATE_TILE_STAIRS,
                Items.DEEPSLATE_TILE_WALL
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.POLISHED_DEEPSLATE,
            ReferenceSet.of(
                Items.POLISHED_DEEPSLATE_STAIRS,
                Items.POLISHED_DEEPSLATE_SLAB,
                Items.POLISHED_DEEPSLATE_WALL,
                Items.DEEPSLATE_BRICKS,
                Items.DEEPSLATE_BRICK_SLAB,
                Items.DEEPSLATE_BRICK_STAIRS,
                Items.DEEPSLATE_BRICK_WALL,
                Items.DEEPSLATE_TILES,
                Items.DEEPSLATE_TILE_SLAB,
                Items.DEEPSLATE_TILE_STAIRS,
                Items.DEEPSLATE_TILE_WALL
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.DEEPSLATE_BRICKS,
            ReferenceSet.of(
                Items.DEEPSLATE_BRICK_STAIRS,
                Items.DEEPSLATE_BRICK_SLAB,
                Items.DEEPSLATE_BRICK_WALL,
                Items.DEEPSLATE_TILES,
                Items.DEEPSLATE_TILE_SLAB,
                Items.DEEPSLATE_TILE_STAIRS,
                Items.DEEPSLATE_TILE_WALL
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.DEEPSLATE_TILES,
            ReferenceSet.of(
                Items.DEEPSLATE_TILE_STAIRS,
                Items.DEEPSLATE_TILE_SLAB,
                Items.DEEPSLATE_TILE_WALL
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.TUFF,
            ReferenceSet.of(
                Items.TUFF_STAIRS,
                Items.TUFF_SLAB,
                Items.TUFF_WALL,
                Items.CHISELED_TUFF,
                Items.POLISHED_TUFF,
                Items.POLISHED_TUFF_STAIRS,
                Items.POLISHED_TUFF_SLAB,
                Items.POLISHED_TUFF_WALL,
                Items.TUFF_BRICKS,
                Items.TUFF_BRICK_STAIRS,
                Items.TUFF_BRICK_SLAB,
                Items.TUFF_BRICK_WALL,
                Items.CHISELED_TUFF_BRICKS
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.POLISHED_TUFF,
            ReferenceSet.of(
                Items.POLISHED_TUFF_STAIRS,
                Items.POLISHED_TUFF_SLAB,
                Items.POLISHED_TUFF_WALL,
                Items.TUFF_BRICKS,
                Items.TUFF_BRICK_STAIRS,
                Items.TUFF_BRICK_SLAB,
                Items.TUFF_BRICK_WALL,
                Items.CHISELED_TUFF_BRICKS
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.TUFF_BRICKS,
            ReferenceSet.of(
                Items.TUFF_BRICK_STAIRS,
                Items.TUFF_BRICK_SLAB,
                Items.TUFF_BRICK_WALL,
                Items.CHISELED_TUFF_BRICKS
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.BRICKS,
            ReferenceSet.of(
                Items.BRICK_STAIRS,
                Items.BRICK_SLAB,
                Items.BRICK_WALL
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.MUD_BRICKS,
            ReferenceSet.of(
                Items.MUD_BRICK_STAIRS,
                Items.MUD_BRICK_SLAB,
                Items.MUD_BRICK_WALL
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.RESIN_BRICKS,
            ReferenceSet.of(
                Items.RESIN_BRICK_STAIRS,
                Items.RESIN_BRICK_SLAB,
                Items.RESIN_BRICK_WALL,
                Items.CHISELED_RESIN_BRICKS
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.SANDSTONE,
            ReferenceSet.of(
                Items.SANDSTONE_STAIRS,
                Items.SANDSTONE_SLAB,
                Items.SANDSTONE_WALL,
                Items.CHISELED_SANDSTONE,
                Items.CUT_SANDSTONE,
                Items.CUT_SANDSTONE_SLAB
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.SMOOTH_SANDSTONE,
            ReferenceSet.of(
                Items.SMOOTH_SANDSTONE_STAIRS,
                Items.SMOOTH_SANDSTONE_SLAB
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.CUT_SANDSTONE,
            ReferenceSet.of(
                Items.CUT_SANDSTONE_SLAB
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.RED_SANDSTONE,
            ReferenceSet.of(
                Items.RED_SANDSTONE_STAIRS,
                Items.RED_SANDSTONE_SLAB,
                Items.RED_SANDSTONE_WALL,
                Items.CHISELED_RED_SANDSTONE,
                Items.CUT_RED_SANDSTONE,
                Items.CUT_RED_SANDSTONE_SLAB
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.SMOOTH_RED_SANDSTONE,
            ReferenceSet.of(
                Items.SMOOTH_RED_SANDSTONE_STAIRS,
                Items.SMOOTH_RED_SANDSTONE_SLAB
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.CUT_RED_SANDSTONE,
            ReferenceSet.of(
                Items.CUT_RED_SANDSTONE_SLAB
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.PRISMARINE,
            ReferenceSet.of(
                Items.PRISMARINE_STAIRS,
                Items.PRISMARINE_SLAB,
                Items.PRISMARINE_WALL
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.PRISMARINE_BRICKS,
            ReferenceSet.of(
                Items.PRISMARINE_BRICK_STAIRS,
                Items.PRISMARINE_BRICK_SLAB
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.DARK_PRISMARINE,
            ReferenceSet.of(
                Items.DARK_PRISMARINE_STAIRS,
                Items.DARK_PRISMARINE_SLAB
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.NETHER_BRICKS,
            ReferenceSet.of(
                Items.NETHER_BRICK_STAIRS,
                Items.NETHER_BRICK_SLAB,
                Items.NETHER_BRICK_WALL,
                Items.CHISELED_NETHER_BRICKS
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.RED_NETHER_BRICKS,
            ReferenceSet.of(
                Items.RED_NETHER_BRICK_STAIRS,
                Items.RED_NETHER_BRICK_SLAB,
                Items.RED_NETHER_BRICK_WALL
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.BASALT,
            ReferenceSet.of(
                Items.POLISHED_BASALT
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.BLACKSTONE,
            ReferenceSet.of(
                Items.BLACKSTONE_STAIRS,
                Items.BLACKSTONE_SLAB,
                Items.BLACKSTONE_WALL,
                Items.CHISELED_POLISHED_BLACKSTONE,
                Items.POLISHED_BLACKSTONE,
                Items.POLISHED_BLACKSTONE_STAIRS,
                Items.POLISHED_BLACKSTONE_SLAB,
                Items.POLISHED_BLACKSTONE_WALL,
                Items.POLISHED_BLACKSTONE_BRICKS,
                Items.POLISHED_BLACKSTONE_BRICK_SLAB,
                Items.POLISHED_BLACKSTONE_BRICK_STAIRS,
                Items.POLISHED_BLACKSTONE_BRICK_WALL
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.POLISHED_BLACKSTONE,
            ReferenceSet.of(
                Items.POLISHED_BLACKSTONE_STAIRS,
                Items.POLISHED_BLACKSTONE_SLAB,
                Items.POLISHED_BLACKSTONE_WALL,
                Items.CHISELED_POLISHED_BLACKSTONE,
                Items.POLISHED_BLACKSTONE_BRICKS,
                Items.POLISHED_BLACKSTONE_BRICK_SLAB,
                Items.POLISHED_BLACKSTONE_BRICK_STAIRS,
                Items.POLISHED_BLACKSTONE_BRICK_WALL
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.POLISHED_BLACKSTONE_BRICKS,
            ReferenceSet.of(
                Items.POLISHED_BLACKSTONE_BRICK_STAIRS,
                Items.POLISHED_BLACKSTONE_BRICK_SLAB,
                Items.POLISHED_BLACKSTONE_BRICK_WALL
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.END_STONE,
            ReferenceSet.of(
                Items.END_STONE_BRICKS,
                Items.END_STONE_BRICK_SLAB,
                Items.END_STONE_BRICK_STAIRS,
                Items.END_STONE_BRICK_WALL
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.END_STONE_BRICKS,
            ReferenceSet.of(
                Items.END_STONE_BRICK_STAIRS,
                Items.END_STONE_BRICK_SLAB,
                Items.END_STONE_BRICK_WALL
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.PURPUR_BLOCK,
            ReferenceSet.of(
                Items.PURPUR_STAIRS,
                Items.PURPUR_SLAB,
                Items.PURPUR_PILLAR
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.QUARTZ_BLOCK,
            ReferenceSet.of(
                Items.QUARTZ_STAIRS,
                Items.QUARTZ_SLAB,
                Items.CHISELED_QUARTZ_BLOCK,
                Items.QUARTZ_BRICKS,
                Items.QUARTZ_PILLAR
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.SMOOTH_QUARTZ,
            ReferenceSet.of(
                Items.SMOOTH_QUARTZ_STAIRS,
                Items.SMOOTH_QUARTZ_SLAB
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.COPPER_BLOCK,
            ReferenceSet.of(
                Items.CHISELED_COPPER,
                Items.COPPER_GRATE,
                Items.CUT_COPPER,
                Items.CUT_COPPER_SLAB,
                Items.CUT_COPPER_STAIRS
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.EXPOSED_COPPER,
            ReferenceSet.of(
                Items.EXPOSED_CHISELED_COPPER,
                Items.EXPOSED_COPPER_GRATE,
                Items.EXPOSED_CUT_COPPER,
                Items.EXPOSED_CUT_COPPER_SLAB,
                Items.EXPOSED_CUT_COPPER_STAIRS
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.WEATHERED_COPPER,
            ReferenceSet.of(
                Items.WEATHERED_CHISELED_COPPER,
                Items.WEATHERED_COPPER_GRATE,
                Items.WEATHERED_CUT_COPPER,
                Items.WEATHERED_CUT_COPPER_SLAB,
                Items.WEATHERED_CUT_COPPER_STAIRS
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.OXIDIZED_COPPER,
            ReferenceSet.of(
                Items.OXIDIZED_CHISELED_COPPER,
                Items.OXIDIZED_COPPER_GRATE,
                Items.OXIDIZED_CUT_COPPER,
                Items.OXIDIZED_CUT_COPPER_SLAB,
                Items.OXIDIZED_CUT_COPPER_STAIRS
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.WAXED_COPPER_BLOCK,
            ReferenceSet.of(
                Items.WAXED_CHISELED_COPPER,
                Items.WAXED_COPPER_GRATE,
                Items.WAXED_CUT_COPPER,
                Items.WAXED_CUT_COPPER_SLAB,
                Items.WAXED_CUT_COPPER_STAIRS
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.WAXED_EXPOSED_COPPER,
            ReferenceSet.of(
                Items.WAXED_EXPOSED_CHISELED_COPPER,
                Items.WAXED_EXPOSED_COPPER_GRATE,
                Items.WAXED_EXPOSED_CUT_COPPER,
                Items.WAXED_EXPOSED_CUT_COPPER_SLAB,
                Items.WAXED_EXPOSED_CUT_COPPER_STAIRS
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.WAXED_WEATHERED_COPPER,
            ReferenceSet.of(
                Items.WAXED_WEATHERED_CHISELED_COPPER,
                Items.WAXED_WEATHERED_COPPER_GRATE,
                Items.WAXED_WEATHERED_CUT_COPPER,
                Items.WAXED_WEATHERED_CUT_COPPER_SLAB,
                Items.WAXED_WEATHERED_CUT_COPPER_STAIRS
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.WAXED_OXIDIZED_COPPER,
            ReferenceSet.of(
                Items.WAXED_OXIDIZED_CHISELED_COPPER,
                Items.WAXED_OXIDIZED_COPPER_GRATE,
                Items.WAXED_OXIDIZED_CUT_COPPER,
                Items.WAXED_OXIDIZED_CUT_COPPER_SLAB,
                Items.WAXED_OXIDIZED_CUT_COPPER_STAIRS
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.CUT_COPPER,
            ReferenceSet.of(
                Items.CUT_COPPER_STAIRS,
                Items.CUT_COPPER_SLAB,
                Items.CHISELED_COPPER
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.EXPOSED_CUT_COPPER,
            ReferenceSet.of(
                Items.EXPOSED_CUT_COPPER_STAIRS,
                Items.EXPOSED_CUT_COPPER_SLAB,
                Items.EXPOSED_CHISELED_COPPER
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.WEATHERED_CUT_COPPER,
            ReferenceSet.of(
                Items.WEATHERED_CUT_COPPER_STAIRS,
                Items.WEATHERED_CUT_COPPER_SLAB,
                Items.WEATHERED_CHISELED_COPPER
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.OXIDIZED_CUT_COPPER,
            ReferenceSet.of(
                Items.OXIDIZED_CUT_COPPER_STAIRS,
                Items.OXIDIZED_CUT_COPPER_SLAB,
                Items.OXIDIZED_CHISELED_COPPER
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.WAXED_CUT_COPPER,
            ReferenceSet.of(
                Items.WAXED_CUT_COPPER_STAIRS,
                Items.WAXED_CUT_COPPER_SLAB,
                Items.WAXED_CHISELED_COPPER
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.WAXED_EXPOSED_CUT_COPPER,
            ReferenceSet.of(
                Items.WAXED_EXPOSED_CUT_COPPER_STAIRS,
                Items.WAXED_EXPOSED_CUT_COPPER_SLAB,
                Items.WAXED_EXPOSED_CHISELED_COPPER
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.WAXED_WEATHERED_CUT_COPPER,
            ReferenceSet.of(
                Items.WAXED_WEATHERED_CUT_COPPER_STAIRS,
                Items.WAXED_WEATHERED_CUT_COPPER_SLAB,
                Items.WAXED_WEATHERED_CHISELED_COPPER
            )
        );
        STONECUTTER_BLOCKS.put(
            Items.WAXED_OXIDIZED_CUT_COPPER,
            ReferenceSet.of(
                Items.WAXED_OXIDIZED_CUT_COPPER_STAIRS,
                Items.WAXED_OXIDIZED_CUT_COPPER_SLAB,
                Items.WAXED_OXIDIZED_CHISELED_COPPER
            )
        );
    }
}
