/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.AbstractCoroutine;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.internal.CoroutineExceptionHandlerImplKt;
import kotlinx.coroutines.internal.StackTraceRecoveryKt;
import kotlinx.coroutines.test.BackgroundWork;
import kotlinx.coroutines.test.TestCoroutineScheduler;
import kotlinx.coroutines.test.TestScope;
import kotlinx.coroutines.test.TestScopeKt;
import kotlinx.coroutines.test.UncaughtExceptionsBeforeTest;
import kotlinx.coroutines.test.UncompletedCoroutinesError;
import kotlinx.coroutines.test.internal.ExceptionCollector;
import kotlinx.coroutines.test.internal.ReportingSupervisorJob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0019\u001a\u00020\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001bJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u001bJ\u000e\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0011J\b\u0010\u001f\u001a\u0004\u0018\u00010\u0011J\b\u0010 \u001a\u00020!H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\""}, d2={"Lkotlinx/coroutines/test/TestScopeImpl;", "Lkotlinx/coroutines/AbstractCoroutine;", "", "Lkotlinx/coroutines/test/TestScope;", "context", "Lkotlin/coroutines/CoroutineContext;", "<init>", "(Lkotlin/coroutines/CoroutineContext;)V", "testScheduler", "Lkotlinx/coroutines/test/TestCoroutineScheduler;", "getTestScheduler", "()Lkotlinx/coroutines/test/TestCoroutineScheduler;", "entered", "", "finished", "uncaughtExceptions", "", "", "lock", "", "Lkotlinx/coroutines/internal/SynchronizedObject;", "backgroundScope", "Lkotlinx/coroutines/CoroutineScope;", "getBackgroundScope", "()Lkotlinx/coroutines/CoroutineScope;", "enter", "leave", "", "legacyLeave", "reportException", "throwable", "tryGetCompletionCause", "toString", "", "kotlinx-coroutines-test"})
@SourceDebugExtension(value={"SMAP\nTestScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestScope.kt\nkotlinx/coroutines/test/TestScopeImpl\n+ 2 Synchronized.common.kt\nkotlinx/coroutines/internal/Synchronized_commonKt\n+ 3 Synchronized.kt\nkotlinx/coroutines/internal/SynchronizedKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 StackTraceRecovery.kt\nkotlinx/coroutines/internal/StackTraceRecoveryKt\n*L\n1#1,330:1\n28#2:331\n28#2:334\n28#2:336\n28#2:338\n16#3:332\n16#3:335\n16#3:337\n16#3:339\n1#4:333\n159#5:340\n*S KotlinDebug\n*F\n+ 1 TestScope.kt\nkotlinx/coroutines/test/TestScopeImpl\n*L\n219#1:331\n246#1:334\n256#1:336\n282#1:338\n219#1:332\n246#1:335\n256#1:337\n282#1:339\n289#1:340\n*E\n"})
public final class TestScopeImpl
extends AbstractCoroutine<Unit>
implements TestScope {
    private boolean entered;
    private boolean finished;
    @NotNull
    private final List<Throwable> uncaughtExceptions = new ArrayList();
    @NotNull
    private final Object lock = new Object();
    @NotNull
    private final CoroutineScope backgroundScope = CoroutineScopeKt.CoroutineScope(this.getCoroutineContext().plus(BackgroundWork.INSTANCE).plus(new ReportingSupervisorJob(null, arg_0 -> TestScopeImpl.backgroundScope$lambda$0(this, arg_0), 1, null)));

    public TestScopeImpl(@NotNull CoroutineContext context) {
        super(context, true, true);
    }

    @Override
    @NotNull
    public TestCoroutineScheduler getTestScheduler() {
        Object e2 = this.getContext().get(TestCoroutineScheduler.Key);
        Intrinsics.checkNotNull(e2);
        return (TestCoroutineScheduler)e2;
    }

    @Override
    @NotNull
    public CoroutineScope getBackgroundScope() {
        return this.backgroundScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enter() {
        List<Throwable> $i$a$-synchronized-TestScopeImpl$enter$exceptions$22;
        Iterator<Throwable> lock$iv = this.lock;
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        Iterator<Throwable> iterator2 = lock$iv;
        synchronized (iterator2) {
            boolean $i$a$-synchronized-TestScopeImpl$enter$exceptions$22 = false;
            if (this.entered) {
                throw new IllegalStateException("Only a single call to `runTest` can be performed during one test.");
            }
            this.entered = true;
            if (!(!this.finished)) {
                throw new IllegalStateException("Check failed.");
            }
            TestScopeImpl $this$enter_u24lambda_u242_u24lambda_u241 = this;
            boolean bl = false;
            CoroutineExceptionHandlerImplKt.ensurePlatformExceptionHandlerLoaded(ExceptionCollector.INSTANCE);
            if (TestScopeKt.getCatchNonTestRelatedExceptions()) {
                ExceptionCollector.INSTANCE.addOnExceptionCallback(this.lock, (Function1<? super Throwable, Unit>)new Function1<Throwable, Unit>((Object)this){

                    public final void invoke(Throwable p0) {
                        ((TestScopeImpl)this.receiver).reportException(p0);
                    }
                });
            }
            $i$a$-synchronized-TestScopeImpl$enter$exceptions$22 = this.uncaughtExceptions;
        }
        List<Throwable> exceptions2 = $i$a$-synchronized-TestScopeImpl$enter$exceptions$22;
        if (!((Collection)exceptions2).isEmpty()) {
            UncaughtExceptionsBeforeTest uncaughtExceptionsBeforeTest;
            ExceptionCollector.INSTANCE.removeOnExceptionCallback(this.lock);
            UncaughtExceptionsBeforeTest $this$enter_u24lambda_u243 = uncaughtExceptionsBeforeTest = new UncaughtExceptionsBeforeTest();
            boolean bl = false;
            for (Throwable e2 : exceptions2) {
                ExceptionsKt.addSuppressed($this$enter_u24lambda_u243, e2);
            }
            throw (Throwable)uncaughtExceptionsBeforeTest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Throwable> leave() {
        List<Throwable> list2;
        Object lock$iv = this.lock;
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        Object object = lock$iv;
        synchronized (object) {
            boolean bl = false;
            if (!(this.entered && !this.finished)) {
                throw new IllegalStateException("Check failed.");
            }
            ExceptionCollector.INSTANCE.removeOnExceptionCallback(this.lock);
            this.finished = true;
            list2 = this.uncaughtExceptions;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Throwable> legacyLeave() {
        List<Throwable> list2;
        Object lock$iv = this.lock;
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        Object object = lock$iv;
        synchronized (object) {
            boolean bl = false;
            if (!(this.entered && !this.finished)) {
                throw new IllegalStateException("Check failed.");
            }
            ExceptionCollector.INSTANCE.removeOnExceptionCallback(this.lock);
            this.finished = true;
            list2 = this.uncaughtExceptions;
        }
        List<Throwable> exceptions2 = list2;
        List<Job> activeJobs = SequencesKt.toList(SequencesKt.filter(this.getChildren(), TestScopeImpl::legacyLeave$lambda$6));
        if (exceptions2.isEmpty()) {
            if (!((Collection)activeJobs).isEmpty()) {
                throw new UncompletedCoroutinesError("Active jobs found during the tear-down. Ensure that all coroutines are completed or cancelled by your test. The active jobs: " + activeJobs);
            }
            if (!TestCoroutineScheduler.isIdle$kotlinx_coroutines_test$default(this.getTestScheduler(), false, 1, null)) {
                throw new UncompletedCoroutinesError("Unfinished coroutines found during the tear-down. Ensure that all coroutines are completed or cancelled by your test.");
            }
        }
        return exceptions2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reportException(@NotNull Throwable throwable) {
        Object lock$iv = this.lock;
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        Object object = lock$iv;
        synchronized (object) {
            boolean bl = false;
            if (this.finished) {
                throw throwable;
            }
            Object object2 = this.uncaughtExceptions.iterator();
            while (object2.hasNext()) {
                Throwable existingThrowable = object2.next();
                boolean $i$f$unwrap = false;
                $i$f$unwrap = false;
                if (!Intrinsics.areEqual(!DebugKt.getRECOVER_STACK_TRACES() ? throwable : StackTraceRecoveryKt.unwrapImpl(throwable), !DebugKt.getRECOVER_STACK_TRACES() ? existingThrowable : StackTraceRecoveryKt.unwrapImpl(existingThrowable))) continue;
                return;
            }
            this.uncaughtExceptions.add(throwable);
            if (!this.entered) {
                Object $this$reportException_u24lambda_u248_u24lambda_u247 = object2 = new UncaughtExceptionsBeforeTest();
                boolean bl2 = false;
                ExceptionsKt.addSuppressed((Throwable)$this$reportException_u24lambda_u248_u24lambda_u247, throwable);
                throw (Throwable)object2;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Nullable
    public final Throwable tryGetCompletionCause() {
        return this.getCompletionCause();
    }

    @Override
    @NotNull
    public String toString() {
        return "TestScope[" + (this.finished ? "test ended" : (this.entered ? "test started" : "test not started")) + ']';
    }

    private static final Unit backgroundScope$lambda$0(TestScopeImpl this$0, Throwable it) {
        if (!(it instanceof CancellationException)) {
            this$0.reportException(it);
        }
        return Unit.INSTANCE;
    }

    private static final boolean legacyLeave$lambda$6(Job it) {
        return it.isActive();
    }
}

