/*
 * Decompiled with CFR 0.152.
 */
package moe.lasoleil.axochat4j.client;

import lombok.Generated;
import moe.lasoleil.axochat4j.client.AxochatClientConnection;
import moe.lasoleil.axochat4j.client.WebSocketConnectionEvent;
import moe.lasoleil.axochat4j.exception.MalformedPacketException;
import moe.lasoleil.axochat4j.exception.PacketIOException;
import moe.lasoleil.axochat4j.packet.AxochatPacket;

final class ClientUtils {
    static boolean safeAccept(AxochatClientConnection connection, AxochatClientConnection.Config config, WebSocketConnectionEvent event) {
        try {
            config.getWebSocketHandler().accept(connection, event);
            return true;
        }
        catch (Throwable t) {
            if (event instanceof WebSocketConnectionEvent.ErrorOccurred) {
                throw t;
            }
            config.getWebSocketHandler().accept(connection, new WebSocketConnectionEvent.ErrorOccurred(t, System.currentTimeMillis()));
            return false;
        }
    }

    static void safeRead(AxochatClientConnection connection, AxochatClientConnection.Config config, String source2) {
        AxochatPacket.S2C packet;
        try {
            packet = (AxochatPacket.S2C)config.getPacketAdapter().read(source2);
        }
        catch (MalformedPacketException | PacketIOException e2) {
            ClientUtils.safeAccept(connection, config, new WebSocketConnectionEvent.UnknownMessageFormat(source2, e2));
            return;
        }
        catch (Throwable t) {
            ClientUtils.safeAccept(connection, config, new WebSocketConnectionEvent.ErrorOccurred(t, System.currentTimeMillis()));
            return;
        }
        try {
            config.getPacketHandler().accept(connection, packet);
        }
        catch (Throwable t) {
            ClientUtils.safeAccept(connection, config, new WebSocketConnectionEvent.ErrorOccurred(t, System.currentTimeMillis()));
        }
    }

    @Generated
    private ClientUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

