/*
 * Decompiled with CFR 0.152.
 */
package net.ccbluex.liquidbounce.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.awt.Color;
import javax.vecmath.Vector2f;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.reflect.KProperty;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import net.ccbluex.liquidbounce.config.Value;
import net.ccbluex.liquidbounce.file.gson.JsonArrayBuilder;
import net.ccbluex.liquidbounce.file.gson.JsonObjectBuilder;
import net.ccbluex.liquidbounce.utils.client.ClientThemesUtils;
import net.ccbluex.liquidbounce.utils.render.ColorUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Mouse;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001?B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0002J\u0006\u00102\u001a\u00020\u0002J\b\u00103\u001a\u000204H\u0016J\u0012\u00105\u001a\u0004\u0018\u00010\u00022\u0006\u00106\u001a\u000204H\u0014J\b\u00107\u001a\u00020\u0004H\u0016J\u0012\u00108\u001a\u0004\u0018\u00010\u00022\u0006\u00109\u001a\u00020\u0004H\u0014J\u001f\u0010:\u001a\u00020\u00022\b\u0010;\u001a\u0004\u0018\u00010<2\n\u0010=\u001a\u0006\u0012\u0002\b\u00030>H\u0096\u0002R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000b\"\u0004\b\u001f\u0010\rR\u001a\u0010 \u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u000b\"\u0004\b\"\u0010\rR\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001e\u0010)\u001a\u0004\u0018\u00010*8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006@"}, d2={"Lnet/ccbluex/liquidbounce/config/ColorValue;", "Lnet/ccbluex/liquidbounce/config/Value;", "Ljava/awt/Color;", "name", "", "defaultColor", "rainbow", "", "<init>", "(Ljava/lang/String;Ljava/awt/Color;Z)V", "getRainbow", "()Z", "setRainbow", "(Z)V", "hueSliderY", "", "getHueSliderY", "()F", "setHueSliderY", "(F)V", "opacitySliderY", "getOpacitySliderY", "setOpacitySliderY", "colorPickerPos", "Ljavax/vecmath/Vector2f;", "getColorPickerPos", "()Ljavax/vecmath/Vector2f;", "setColorPickerPos", "(Ljavax/vecmath/Vector2f;)V", "showPicker", "getShowPicker", "setShowPicker", "showOptions", "getShowOptions", "setShowOptions", "rgbaIndex", "", "getRgbaIndex", "()I", "setRgbaIndex", "(I)V", "lastChosenSlider", "Lnet/ccbluex/liquidbounce/config/ColorValue$SliderType;", "getLastChosenSlider", "()Lnet/ccbluex/liquidbounce/config/ColorValue$SliderType;", "setLastChosenSlider", "(Lnet/ccbluex/liquidbounce/config/ColorValue$SliderType;)V", "setupSliders", "", "color", "selectedColor", "toJson", "Lcom/google/gson/JsonElement;", "fromJsonF", "element", "toText", "fromTextF", "text", "getValue", "thisRef", "", "property", "Lkotlin/reflect/KProperty;", "SliderType", "FDPClient"})
@SourceDebugExtension(value={"SMAP\nValues.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Values.kt\nnet/ccbluex/liquidbounce/config/ColorValue\n+ 2 GsonExtensions.kt\nnet/ccbluex/liquidbounce/file/gson/GsonExtensionsKt\n*L\n1#1,455:1\n71#2:456\n77#2:457\n*S KotlinDebug\n*F\n+ 1 Values.kt\nnet/ccbluex/liquidbounce/config/ColorValue\n*L\n378#1:456\n379#1:457\n*E\n"})
public final class ColorValue
extends Value<Color> {
    private boolean rainbow;
    private float hueSliderY;
    private float opacitySliderY;
    @NotNull
    private Vector2f colorPickerPos;
    private boolean showPicker;
    private boolean showOptions;
    private int rgbaIndex;
    @Nullable
    private SliderType lastChosenSlider;

    public ColorValue(@NotNull String name, @NotNull Color defaultColor, boolean rainbow) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(defaultColor, "defaultColor");
        super(name, defaultColor, null, null, 12, null);
        this.rainbow = rainbow;
        this.colorPickerPos = new Vector2f(0.0f, 0.0f);
        this.setupSliders(defaultColor);
        this.onChanged((Function1)new Function1<Color, Unit>((Object)this){

            @Override
            public final void invoke(Color p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                ((ColorValue)this.receiver).setupSliders(p0);
            }
        });
    }

    public /* synthetic */ ColorValue(String string, Color color, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(string, color, bl);
    }

    public final boolean getRainbow() {
        return this.rainbow;
    }

    public final void setRainbow(boolean bl) {
        this.rainbow = bl;
    }

    public final float getHueSliderY() {
        return this.hueSliderY;
    }

    public final void setHueSliderY(float f) {
        this.hueSliderY = f;
    }

    public final float getOpacitySliderY() {
        return this.opacitySliderY;
    }

    public final void setOpacitySliderY(float f) {
        this.opacitySliderY = f;
    }

    @NotNull
    public final Vector2f getColorPickerPos() {
        return this.colorPickerPos;
    }

    public final void setColorPickerPos(@NotNull Vector2f vector2f) {
        Intrinsics.checkNotNullParameter(vector2f, "<set-?>");
        this.colorPickerPos = vector2f;
    }

    public final boolean getShowPicker() {
        return this.showPicker;
    }

    public final void setShowPicker(boolean bl) {
        this.showPicker = bl;
    }

    public final boolean getShowOptions() {
        return this.showOptions;
    }

    public final void setShowOptions(boolean bl) {
        this.showOptions = bl;
    }

    public final int getRgbaIndex() {
        return this.rgbaIndex;
    }

    public final void setRgbaIndex(int n) {
        this.rgbaIndex = n;
    }

    @Nullable
    public final SliderType getLastChosenSlider() {
        if (!Mouse.isButtonDown((int)0)) {
            this.lastChosenSlider = null;
        }
        return this.lastChosenSlider;
    }

    public final void setLastChosenSlider(@Nullable SliderType sliderType) {
        this.lastChosenSlider = sliderType;
    }

    public final void setupSliders(@NotNull Color color) {
        float[] fArray;
        Intrinsics.checkNotNullParameter(color, "color");
        float[] it = fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        boolean bl = false;
        this.hueSliderY = it[0];
        this.opacitySliderY = (float)color.getAlpha() / 255.0f;
        this.colorPickerPos.set(it[1], 1.0f - it[2]);
    }

    @NotNull
    public final Color selectedColor() {
        return this.rainbow ? ColorUtils.INSTANCE.withAlpha(ClientThemesUtils.getColor$default(ClientThemesUtils.INSTANCE, 0, 1, null), MathKt.roundToInt(this.opacitySliderY * (float)255)) : (Color)this.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsonElement toJson() {
        void $this$toJson_u24lambda_u242_u24lambda_u241;
        JsonArrayBuilder jsonArrayBuilder;
        JsonObjectBuilder jsonObjectBuilder;
        Vector2f pos = this.colorPickerPos;
        boolean $i$f$json = false;
        JsonObjectBuilder $this$toJson_u24lambda_u242 = jsonObjectBuilder = new JsonObjectBuilder();
        boolean bl = false;
        boolean $i$f$jsonArray = false;
        JsonArrayBuilder jsonArrayBuilder2 = jsonArrayBuilder = new JsonArrayBuilder();
        String string = "ColorPicker";
        JsonObjectBuilder jsonObjectBuilder2 = $this$toJson_u24lambda_u242;
        boolean bl2 = false;
        $this$toJson_u24lambda_u242_u24lambda_u241.unaryPlus((JsonElement)new JsonPrimitive((Number)Float.valueOf(pos.x)));
        $this$toJson_u24lambda_u242_u24lambda_u241.unaryPlus((JsonElement)new JsonPrimitive((Number)Float.valueOf(pos.y)));
        Unit unit = Unit.INSTANCE;
        jsonObjectBuilder2.to(string, (JsonElement)jsonArrayBuilder.build());
        $this$toJson_u24lambda_u242.to("HueSliderY", Float.valueOf(this.hueSliderY));
        $this$toJson_u24lambda_u242.to("OpacitySliderY", Float.valueOf(this.opacitySliderY));
        $this$toJson_u24lambda_u242.to("Rainbow", this.rainbow);
        return (JsonElement)jsonObjectBuilder.build();
    }

    @Override
    @Nullable
    protected Color fromJsonF(@NotNull JsonElement element) {
        Color color;
        Intrinsics.checkNotNullParameter(element, "element");
        if (element instanceof JsonObject) {
            Color color2;
            try {
                float colorPickerX = ((JsonObject)element).get("ColorPicker").getAsJsonArray().get(0).getAsFloat();
                float colorPickerY = ((JsonObject)element).get("ColorPicker").getAsJsonArray().get(1).getAsFloat();
                float hueSliderY = ((JsonObject)element).get("HueSliderY").getAsFloat();
                float opacitySliderY = ((JsonObject)element).get("OpacitySliderY").getAsFloat();
                boolean rainbowString = ((JsonObject)element).get("Rainbow").getAsBoolean();
                this.colorPickerPos = new Vector2f(colorPickerX, colorPickerY);
                this.hueSliderY = hueSliderY;
                this.opacitySliderY = opacitySliderY;
                this.rainbow = rainbowString;
                color2 = ColorUtils.INSTANCE.withAlpha(new Color(Color.HSBtoRGB(this.hueSliderY, colorPickerX, 1.0f - colorPickerY), true), MathKt.roundToInt(opacitySliderY * (float)255));
            }
            catch (Exception exception) {
                color2 = null;
            }
            color = color2;
        } else {
            color = null;
        }
        return color;
    }

    @Override
    @NotNull
    public String toText() {
        return "Color(ColorPicker=[" + this.colorPickerPos.x + ',' + this.colorPickerPos.y + "],HueSliderY=" + this.hueSliderY + ",OpacitySliderY=" + this.opacitySliderY + ",Rainbow=" + this.rainbow + ')';
    }

    @Override
    @Nullable
    protected Color fromTextF(@NotNull String text) {
        Color color;
        Intrinsics.checkNotNullParameter(text, "text");
        try {
            Regex colorPickerRegex = new Regex("ColorPicker=\\[(\\d+\\.?\\d*),(\\d+\\.?\\d*)]");
            MatchResult colorPickerMatch = Regex.find$default(colorPickerRegex, text, 0, 2, null);
            Object object = colorPickerMatch;
            if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
                return null;
            }
            float colorPickerX = Float.parseFloat((String)object);
            float colorPickerY = Float.parseFloat(colorPickerMatch.getGroupValues().get(2));
            Regex hueSliderRegex = new Regex("HueSliderY=(\\d+\\.?\\d*)");
            MatchResult hueSliderMatch = Regex.find$default(hueSliderRegex, text, 0, 2, null);
            Object object2 = hueSliderMatch;
            if (object2 == null || (object2 = object2.getGroupValues()) == null || (object2 = (String)object2.get(1)) == null) {
                return null;
            }
            float hueSliderY = Float.parseFloat((String)object2);
            Regex opacitySliderRegex = new Regex("OpacitySliderY=(\\d+\\.?\\d*)");
            MatchResult opacitySliderMatch = Regex.find$default(opacitySliderRegex, text, 0, 2, null);
            Object object3 = opacitySliderMatch;
            if (object3 == null || (object3 = object3.getGroupValues()) == null || (object3 = (String)object3.get(1)) == null) {
                return null;
            }
            float opacitySliderY = Float.parseFloat((String)object3);
            Regex rainbowRegex = new Regex("Rainbow=(true|false)");
            MatchResult rainbowMatch = Regex.find$default(rainbowRegex, text, 0, 2, null);
            Object object4 = rainbowMatch;
            if (object4 == null || (object4 = object4.getGroupValues()) == null || (object4 = (String)object4.get(1)) == null) {
                return null;
            }
            boolean rainbow = Boolean.parseBoolean((String)object4);
            this.colorPickerPos = new Vector2f(colorPickerX, colorPickerY);
            this.hueSliderY = hueSliderY;
            this.opacitySliderY = opacitySliderY;
            this.rainbow = rainbow;
            color = ColorUtils.INSTANCE.withAlpha(new Color(Color.HSBtoRGB(this.hueSliderY, colorPickerX, 1.0f - colorPickerY), true), MathKt.roundToInt(opacitySliderY * (float)255));
        }
        catch (Exception exception) {
            color = null;
        }
        return color;
    }

    @Override
    @NotNull
    public Color getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
        Intrinsics.checkNotNullParameter(property, "property");
        return this.selectedColor();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/ccbluex/liquidbounce/config/ColorValue$SliderType;", "", "<init>", "(Ljava/lang/String;I)V", "COLOR", "HUE", "OPACITY", "FDPClient"})
    public static final class SliderType
    extends Enum<SliderType> {
        public static final /* enum */ SliderType COLOR = new SliderType();
        public static final /* enum */ SliderType HUE = new SliderType();
        public static final /* enum */ SliderType OPACITY = new SliderType();
        private static final /* synthetic */ SliderType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SliderType[] values() {
            return (SliderType[])$VALUES.clone();
        }

        public static SliderType valueOf(String value) {
            return Enum.valueOf(SliderType.class, value);
        }

        @NotNull
        public static EnumEntries<SliderType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sliderTypeArray = new SliderType[]{SliderType.COLOR, SliderType.HUE, SliderType.OPACITY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

