/*
 * Decompiled with CFR 0.152.
 */
package net.ccbluex.liquidbounce.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.ccbluex.liquidbounce.config.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0014\u00a2\u0006\u0002\u0010\u0018J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u0004H\u0014\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u0011J\u0006\u0010\u001d\u001a\u00020\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u001e\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 \u00a8\u0006#"}, d2={"Lnet/ccbluex/liquidbounce/config/FloatValue;", "Lnet/ccbluex/liquidbounce/config/Value;", "", "name", "", "value", "range", "Lkotlin/ranges/ClosedFloatingPointRange;", "suffix", "<init>", "(Ljava/lang/String;FLkotlin/ranges/ClosedFloatingPointRange;Ljava/lang/String;)V", "getRange", "()Lkotlin/ranges/ClosedFloatingPointRange;", "validate", "newValue", "(F)Ljava/lang/Float;", "set", "", "", "toJson", "Lcom/google/gson/JsonPrimitive;", "fromJsonF", "element", "Lcom/google/gson/JsonElement;", "(Lcom/google/gson/JsonElement;)Ljava/lang/Float;", "fromTextF", "text", "(Ljava/lang/String;)Ljava/lang/Float;", "isMinimal", "isMaximal", "minimum", "getMinimum", "()F", "maximum", "getMaximum", "FDPClient"})
public final class FloatValue
extends Value<Float> {
    @NotNull
    private final ClosedFloatingPointRange<Float> range;
    private final float minimum;
    private final float maximum;

    public FloatValue(@NotNull String name, float value, @NotNull ClosedFloatingPointRange<Float> range, @Nullable String suffix) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(range, "range");
        super(name, Float.valueOf(value), suffix, null, 8, null);
        this.range = range;
        this.minimum = ((Number)this.range.getStart()).floatValue();
        this.maximum = ((Number)this.range.getEndInclusive()).floatValue();
    }

    public /* synthetic */ FloatValue(String string, float f, ClosedFloatingPointRange closedFloatingPointRange, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        this(string, f, closedFloatingPointRange, string2);
    }

    @NotNull
    public final ClosedFloatingPointRange<Float> getRange() {
        return this.range;
    }

    @Override
    @NotNull
    public Float validate(float newValue) {
        return RangesKt.coerceIn((Comparable)Float.valueOf(newValue), this.range);
    }

    public final boolean set(@NotNull Number newValue) {
        Intrinsics.checkNotNullParameter(newValue, "newValue");
        return Value.set$default(this, Float.valueOf(newValue.floatValue()), false, 2, null);
    }

    @NotNull
    public JsonPrimitive toJson() {
        return new JsonPrimitive((Number)this.getValue());
    }

    @Override
    @Nullable
    protected Float fromJsonF(@NotNull JsonElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return element.isJsonPrimitive() ? Float.valueOf(element.getAsFloat()) : null;
    }

    @Override
    @Nullable
    protected Float fromTextF(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        return StringsKt.toFloatOrNull(text);
    }

    public final boolean isMinimal() {
        return ((Number)this.getValue()).floatValue() <= this.minimum;
    }

    public final boolean isMaximal() {
        return ((Number)this.getValue()).floatValue() >= this.maximum;
    }

    public final float getMinimum() {
        return this.minimum;
    }

    public final float getMaximum() {
        return this.maximum;
    }
}

