/*
 * Decompiled with CFR 0.152.
 */
package net.ccbluex.liquidbounce.features.command.commands;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.ccbluex.liquidbounce.event.Event;
import net.ccbluex.liquidbounce.event.EventHook;
import net.ccbluex.liquidbounce.event.EventManager;
import net.ccbluex.liquidbounce.event.GameTickEvent;
import net.ccbluex.liquidbounce.event.Listenable;
import net.ccbluex.liquidbounce.event.PacketEvent;
import net.ccbluex.liquidbounce.event.WorldEvent;
import net.ccbluex.liquidbounce.features.command.Command;
import net.minecraft.network.play.server.S03PacketTimeUpdate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001b\u0010\u001a\u001a\u00020\u00122\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0016\u001a\u00020\u0012\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0017\u0010\u0014R\u0013\u0010\u0018\u001a\u00020\u0012\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0019\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lnet/ccbluex/liquidbounce/features/command/commands/TpsCommand;", "Lnet/ccbluex/liquidbounce/features/command/Command;", "Lnet/ccbluex/liquidbounce/event/Listenable;", "<init>", "()V", "AVG_SIZE", "", "intervals", "Ljava/util/ArrayDeque;", "", "lastTimeUpdateAt", "currentTps", "", "watching", "", "tickCounter", "periodTicks", "onPacket", "", "getOnPacket", "()Lkotlin/Unit;", "Lkotlin/Unit;", "onTick", "getOnTick", "onWorld", "getOnWorld", "execute", "args", "", "", "([Ljava/lang/String;)V", "FDPClient"})
@SourceDebugExtension(value={"SMAP\nTpsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TpsCommand.kt\nnet/ccbluex/liquidbounce/features/command/commands/TpsCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Listenable.kt\nnet/ccbluex/liquidbounce/event/ListenableKt\n*L\n1#1,92:1\n1#2:93\n1557#3:94\n1628#3,3:95\n22#4,7:98\n22#4,7:105\n22#4,7:112\n*S KotlinDebug\n*F\n+ 1 TpsCommand.kt\nnet/ccbluex/liquidbounce/features/command/commands/TpsCommand\n*L\n36#1:94\n36#1:95,3\n29#1:98,7\n46#1:105,7\n56#1:112,7\n*E\n"})
public final class TpsCommand
extends Command
implements Listenable {
    @NotNull
    public static final TpsCommand INSTANCE;
    private static final int AVG_SIZE = 15;
    @NotNull
    private static final ArrayDeque<Long> intervals;
    private static long lastTimeUpdateAt;
    private static double currentTps;
    private static boolean watching;
    private static int tickCounter;
    private static int periodTicks;
    @NotNull
    private static final Unit onPacket;
    @NotNull
    private static final Unit onTick;
    @NotNull
    private static final Unit onWorld;

    private TpsCommand() {
        super("tps", new String[0]);
    }

    @NotNull
    public final Unit getOnPacket() {
        return onPacket;
    }

    @NotNull
    public final Unit getOnTick() {
        return onTick;
    }

    @NotNull
    public final Unit getOnWorld() {
        return onWorld;
    }

    @Override
    public void execute(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter(args, "args");
        if (args.length <= 1) {
            if (Double.isNaN(currentTps)) {
                this.chat("\u00a7cTPS not available. Wait a few seconds.");
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("\u00a73Server TPS is \u00a7a");
                String string = "%.2f";
                Object[] objectArray = new Object[]{currentTps};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                this.chat(stringBuilder.append(string2).append("\u00a73.").toString());
            }
            return;
        }
        String string = args[1].toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        switch (string) {
            case "watch": 
            case "start": {
                int n;
                Object object = ArraysKt.getOrNull(args, 2);
                if (object != null && (object = StringsKt.toIntOrNull((String)object)) != null) {
                    int it = ((Number)object).intValue();
                    boolean bl = false;
                    n = RangesKt.coerceIn(it * 20, 5, 200);
                } else {
                    n = 20;
                }
                periodTicks = n;
                watching = true;
                tickCounter = 0;
                this.chat("\u00a7aTPS watcher started (\u00a77every " + periodTicks / 20 + "s\u00a7a).");
                break;
            }
            case "stop": 
            case "off": {
                if (watching) {
                    watching = false;
                    this.chat("\u00a7aTPS watcher stopped.");
                    break;
                }
                this.chat("\u00a7cTPS watcher is not running.");
                break;
            }
            case "once": {
                if (Double.isNaN(currentTps)) {
                    this.chat("\u00a7cTPS not available. Wait a few seconds.");
                    break;
                }
                StringBuilder stringBuilder = new StringBuilder().append("\u00a73Server TPS is \u00a7a");
                String string3 = "%.2f";
                Object[] objectArray = new Object[]{currentTps};
                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
                this.chat(stringBuilder.append(string4).append("\u00a73.").toString());
                break;
            }
            default: {
                this.chat("\u00a77Usage: \u00a7b.tps \u00a77| \u00a7b.tps watch [seconds] \u00a77| \u00a7b.tps stop \u00a77| \u00a7b.tps once");
            }
        }
    }

    @Override
    public boolean handleEvents() {
        return Listenable.DefaultImpls.handleEvents(this);
    }

    @Override
    @NotNull
    public Listenable[] getSubListeners() {
        return Listenable.DefaultImpls.getSubListeners(this);
    }

    @Override
    @Nullable
    public Listenable getParent() {
        return Listenable.DefaultImpls.getParent(this);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onPacket$lambda$1(PacketEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getPacket() instanceof S03PacketTimeUpdate) {
            long now = System.currentTimeMillis();
            if (lastTimeUpdateAt > 0L) {
                double d2;
                void $this$mapTo$iv$iv;
                long delta = now - lastTimeUpdateAt;
                intervals.addLast(delta);
                while (intervals.size() > 15) {
                    intervals.removeFirst();
                }
                Iterable $this$map$iv = intervals;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Long l = (Long)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Double.valueOf(it.longValue()));
                }
                double avgMs = CollectionsKt.averageOfDouble((List)destination$iv$iv);
                if (avgMs > 0.0 && !Double.isNaN(avgMs)) {
                    double v = 20.0 / (avgMs / 1000.0);
                    d2 = Math.min(20.0, Math.max(0.0, v));
                } else {
                    d2 = Double.NaN;
                }
                currentTps = d2;
            }
            lastTimeUpdateAt = now;
        }
        return Unit.INSTANCE;
    }

    private static final Unit onTick$lambda$2(GameTickEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (!watching) {
            return Unit.INSTANCE;
        }
        int n = tickCounter;
        tickCounter = n + 1;
        if (tickCounter >= periodTicks) {
            tickCounter = 0;
            if (Double.isNaN(currentTps)) {
                INSTANCE.chat("\u00a7cTPS not available. Wait a few seconds.");
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("\u00a73Server TPS is \u00a7a");
                String string = "%.2f";
                Object[] objectArray = new Object[]{currentTps};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                INSTANCE.chat(stringBuilder.append(string2).append("\u00a73.").toString());
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit onWorld$lambda$3(WorldEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        intervals.clear();
        lastTimeUpdateAt = -1L;
        currentTps = Double.NaN;
        tickCounter = 0;
        return Unit.INSTANCE;
    }

    static {
        Listenable $this$handler_u24default$iv;
        INSTANCE = new TpsCommand();
        intervals = new ArrayDeque(16);
        lastTimeUpdateAt = -1L;
        currentTps = Double.NaN;
        periodTicks = 20;
        Listenable listenable = INSTANCE;
        Function1<Event, Unit> action$iv = TpsCommand::onPacket$lambda$1;
        boolean always$iv = false;
        byte priority$iv = 0;
        boolean $i$f$handler = false;
        EventManager.INSTANCE.registerEventHook(PacketEvent.class, new EventHook<PacketEvent>($this$handler_u24default$iv, always$iv, priority$iv, action$iv));
        onPacket = Unit.INSTANCE;
        $this$handler_u24default$iv = INSTANCE;
        action$iv = TpsCommand::onTick$lambda$2;
        always$iv = false;
        priority$iv = 0;
        $i$f$handler = false;
        EventManager.INSTANCE.registerEventHook(GameTickEvent.class, new EventHook<PacketEvent>($this$handler_u24default$iv, always$iv, priority$iv, action$iv));
        onTick = Unit.INSTANCE;
        $this$handler_u24default$iv = INSTANCE;
        action$iv = TpsCommand::onWorld$lambda$3;
        always$iv = false;
        priority$iv = 0;
        $i$f$handler = false;
        EventManager.INSTANCE.registerEventHook(WorldEvent.class, new EventHook<PacketEvent>($this$handler_u24default$iv, always$iv, priority$iv, action$iv));
        onWorld = Unit.INSTANCE;
    }
}

