/*
 * Decompiled with CFR 0.152.
 */
package net.ccbluex.liquidbounce.file.configs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.liuli.elixir.account.CrackedAccount;
import me.liuli.elixir.account.MinecraftAccount;
import me.liuli.elixir.account.MojangAccount;
import me.liuli.elixir.manage.AccountSerializer;
import net.ccbluex.liquidbounce.file.FileConfig;
import net.ccbluex.liquidbounce.file.FileManager;
import net.ccbluex.liquidbounce.utils.io.FileExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\bJ\u0006\u0010\u001b\u001a\u00020\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lnet/ccbluex/liquidbounce/file/configs/AccountsConfig;", "Lnet/ccbluex/liquidbounce/file/FileConfig;", "file", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "accounts", "", "Lme/liuli/elixir/account/MinecraftAccount;", "getAccounts", "()Ljava/util/List;", "loadConfig", "", "saveConfig", "addCrackedAccount", "name", "", "addMojangAccount", "password", "addAccount", "", "account", "removeAccount", "selectedSlot", "", "accountExists", "newAccount", "clearAccounts", "FDPClient"})
@SourceDebugExtension(value={"SMAP\nAccountsConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountsConfig.kt\nnet/ccbluex/liquidbounce/file/configs/AccountsConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1755#2,3:145\n*S KotlinDebug\n*F\n+ 1 AccountsConfig.kt\nnet/ccbluex/liquidbounce/file/configs/AccountsConfig\n*L\n138#1:145,3\n*E\n"})
public final class AccountsConfig
extends FileConfig {
    @NotNull
    private final List<MinecraftAccount> accounts;

    public AccountsConfig(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        super(file);
        this.accounts = new ArrayList();
    }

    @NotNull
    public final List<MinecraftAccount> getAccounts() {
        return this.accounts;
    }

    @Override
    public void loadConfig() throws IOException {
        this.clearAccounts();
        JsonElement jsonElement = FileExtensionsKt.readJson(this.getFile());
        JsonArray jsonArray = jsonElement instanceof JsonArray ? (JsonArray)jsonElement : null;
        if (jsonArray == null) {
            return;
        }
        JsonArray json = jsonArray;
        Iterator iterator2 = json.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            CrackedAccount crackedAccount;
            MojangAccount mojangAccount;
            JsonElement inGameName;
            JsonElement password;
            JsonElement name;
            JsonElement accountElement = (JsonElement)iterator3.next();
            JsonObject accountObject = accountElement.getAsJsonObject();
            try {
                Collection collection = this.accounts;
                JsonObject jsonObject = accountElement.getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue(jsonObject, "getAsJsonObject(...)");
                collection.add(AccountSerializer.INSTANCE.fromJson(jsonObject));
            }
            catch (JsonSyntaxException e2) {
                name = accountObject.get("name");
                password = accountObject.get("password");
                inGameName = accountObject.get("inGameName");
                if (inGameName.isJsonNull() && password.isJsonNull()) {
                    mojangAccount = new MojangAccount();
                    mojangAccount.setEmail(name.getAsString());
                    mojangAccount.setName(inGameName.getAsString());
                    mojangAccount.setPassword(password.getAsString());
                    ((Collection)this.accounts).add(mojangAccount);
                    continue;
                }
                crackedAccount = new CrackedAccount();
                crackedAccount.setName(name.getAsString());
                ((Collection)this.accounts).add(crackedAccount);
            }
            catch (IllegalStateException e3) {
                name = accountObject.get("name");
                password = accountObject.get("password");
                inGameName = accountObject.get("inGameName");
                if (inGameName.isJsonNull() && password.isJsonNull()) {
                    mojangAccount = new MojangAccount();
                    mojangAccount.setEmail(name.getAsString());
                    mojangAccount.setName(inGameName.getAsString());
                    mojangAccount.setPassword(password.getAsString());
                    ((Collection)this.accounts).add(mojangAccount);
                    continue;
                }
                crackedAccount = new CrackedAccount();
                crackedAccount.setName(name.getAsString());
                ((Collection)this.accounts).add(crackedAccount);
            }
        }
    }

    @Override
    public void saveConfig() throws IOException {
        JsonArray jsonArray = new JsonArray();
        for (MinecraftAccount minecraftAccount : this.accounts) {
            jsonArray.add((JsonElement)AccountSerializer.INSTANCE.toJson(minecraftAccount));
        }
        File file = this.getFile();
        String string = FileManager.INSTANCE.getPRETTY_GSON().toJson((JsonElement)jsonArray);
        Intrinsics.checkNotNullExpressionValue(string, "toJson(...)");
        FilesKt.writeText$default(file, string, null, 2, null);
    }

    public final void addCrackedAccount(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        CrackedAccount crackedAccount = new CrackedAccount();
        crackedAccount.setName(name);
        if (!this.accountExists(crackedAccount)) {
            ((Collection)this.accounts).add(crackedAccount);
        }
    }

    public final void addMojangAccount(@NotNull String name, @NotNull String password) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(password, "password");
        MojangAccount mojangAccount = new MojangAccount();
        mojangAccount.setName(name);
        mojangAccount.setPassword(password);
        if (!this.accountExists(mojangAccount)) {
            ((Collection)this.accounts).add(mojangAccount);
        }
    }

    public final boolean addAccount(@NotNull MinecraftAccount account) {
        Intrinsics.checkNotNullParameter(account, "account");
        return this.accounts.add(account);
    }

    @NotNull
    public final MinecraftAccount removeAccount(int selectedSlot) {
        return this.accounts.remove(selectedSlot);
    }

    public final boolean removeAccount(@NotNull MinecraftAccount account) {
        Intrinsics.checkNotNullParameter(account, "account");
        return this.accounts.remove(account);
    }

    public final boolean accountExists(@NotNull MinecraftAccount newAccount) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(newAccount, "newAccount");
            Iterable $this$any$iv = this.accounts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MinecraftAccount it = (MinecraftAccount)element$iv;
                    boolean bl2 = false;
                    if (!(it.getClass() == newAccount.getClass() && Intrinsics.areEqual(it.getName(), newAccount.getName()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void clearAccounts() {
        this.accounts.clear();
    }
}

