/*
 * Decompiled with CFR 0.152.
 */
package net.ccbluex.liquidbounce.utils.block;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.ccbluex.liquidbounce.utils.block.BlockExtensionKt;
import net.ccbluex.liquidbounce.utils.client.MinecraftInstance;
import net.ccbluex.liquidbounce.utils.extensions.MathExtensionsKt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockSoulSand;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\t2\b\b\u0002\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bJY\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0010\b\u0002\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u001a\b\u0002\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\t0\u001c\u00a2\u0006\u0002\u0010\u001dJ(\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 2\u0018\u0010!\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\t0\"j\u0002`#J(\u0010$\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 2\u0018\u0010!\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\t0\"j\u0002`#J\u000e\u0010)\u001a\u00020*2\u0006\u0010\u0011\u001a\u00020\u0012R\u001f\u0010%\u001a\u0010\u0012\f\u0012\n &*\u0004\u0018\u00010\u00120\u00120\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006+"}, d2={"Lnet/ccbluex/liquidbounce/utils/block/BlockUtils;", "Lnet/ccbluex/liquidbounce/utils/client/MinecraftInstance;", "<init>", "()V", "getBlockName", "", "id", "", "isBlockBBValid", "", "blockPos", "Lnet/minecraft/util/BlockPos;", "blockState", "Lnet/minecraft/block/state/IBlockState;", "supportSlabs", "supportPartialBlocks", "isFullBlock", "block", "Lnet/minecraft/block/Block;", "getCenterDistance", "", "searchBlocks", "", "radius", "targetBlocks", "", "maxBlocksLimit", "predicate", "Lkotlin/Function2;", "(ILjava/util/Set;Ljava/lang/Integer;Lkotlin/jvm/functions/Function2;)Ljava/util/Map;", "collideBlock", "axisAlignedBB", "Lnet/minecraft/util/AxisAlignedBB;", "collide", "Lkotlin/Function1;", "Lnet/ccbluex/liquidbounce/utils/block/Collidable;", "collideBlockIntersects", "BEDWARS_BLOCKS", "kotlin.jvm.PlatformType", "getBEDWARS_BLOCKS", "()Ljava/util/Set;", "getBlockTexture", "Lnet/minecraft/util/ResourceLocation;", "FDPClient"})
@SourceDebugExtension(value={"SMAP\nBlockUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockUtils.kt\nnet/ccbluex/liquidbounce/utils/block/BlockUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
public final class BlockUtils
implements MinecraftInstance {
    @NotNull
    public static final BlockUtils INSTANCE = new BlockUtils();
    @NotNull
    private static final Set<Block> BEDWARS_BLOCKS;

    private BlockUtils() {
    }

    @NotNull
    public final String getBlockName(int id) {
        String string = Block.func_149729_e((int)id).func_149732_F();
        Intrinsics.checkNotNullExpressionValue(string, "getLocalizedName(...)");
        return string;
    }

    public final boolean isBlockBBValid(@NotNull BlockPos blockPos, @Nullable IBlockState blockState, boolean supportSlabs, boolean supportPartialBlocks) {
        Intrinsics.checkNotNullParameter(blockPos, "blockPos");
        IBlockState iBlockState = blockState;
        if (iBlockState == null && (iBlockState = BlockExtensionKt.getState(blockPos)) == null) {
            return false;
        }
        IBlockState state = iBlockState;
        AxisAlignedBB axisAlignedBB = state.func_177230_c().func_180640_a((World)this.getMc().field_71441_e, blockPos, state);
        if (axisAlignedBB == null) {
            return false;
        }
        AxisAlignedBB box = axisAlignedBB;
        if (supportPartialBlocks && (box.field_72337_e - box.field_72338_b < 1.0 || box.field_72336_d - box.field_72340_a < 1.0 || box.field_72334_f - box.field_72339_c < 1.0)) {
            return true;
        }
        return box.field_72336_d - box.field_72340_a == 1.0 && (box.field_72337_e - box.field_72338_b == 1.0 || supportSlabs && box.field_72337_e % 1.0 == 0.0) && box.field_72334_f - box.field_72339_c == 1.0;
    }

    public static /* synthetic */ boolean isBlockBBValid$default(BlockUtils blockUtils, BlockPos blockPos, IBlockState iBlockState, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            iBlockState = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return blockUtils.isBlockBBValid(blockPos, iBlockState, bl, bl2);
    }

    public final boolean isFullBlock(@NotNull Block block) {
        Intrinsics.checkNotNullParameter(block, "block");
        Block block2 = block;
        if (block2 instanceof BlockSoulSand) {
            return false;
        }
        if (block2 instanceof BlockGlass || block2 instanceof BlockStainedGlass) {
            return true;
        }
        return block.func_149730_j() && block.func_149637_q() && block.func_149753_y() == 1.0 && block.func_149669_A() == 1.0 && block.func_149693_C() == 1.0;
    }

    public final double getCenterDistance(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter(blockPos, "blockPos");
        return this.getMc().field_71439_g.func_70011_f((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5);
    }

    @NotNull
    public final Map<BlockPos, Block> searchBlocks(int radius, @Nullable Set<? extends Block> targetBlocks, @Nullable Integer maxBlocksLimit, @NotNull Function2<? super BlockPos, ? super Block, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        EntityPlayerSP entityPlayerSP = this.getMc().field_71439_g;
        if (entityPlayerSP == null) {
            return new LinkedHashMap();
        }
        EntityPlayerSP thePlayer = entityPlayerSP;
        Map blocks = new LinkedHashMap();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(0, 0, 0);
        int n = -radius + 1;
        int x = radius;
        if (n <= x) {
            while (true) {
                int y;
                int n2;
                if ((n2 = -radius + 1) <= (y = radius)) {
                    while (true) {
                        int z;
                        int n3;
                        if ((n3 = -radius + 1) <= (z = radius)) {
                            while (true) {
                                BlockPos pos;
                                Block block;
                                if (maxBlocksLimit != null && blocks.size() >= maxBlocksLimit) {
                                    return blocks;
                                }
                                mutable.func_181079_c((int)thePlayer.field_70165_t + x, (int)thePlayer.field_70163_u + y, (int)thePlayer.field_70161_v + z);
                                if (BlockExtensionKt.getBlock((BlockPos)mutable) != null && (targetBlocks == null || targetBlocks.contains(block)) && predicate.invoke((BlockPos)(pos = MathExtensionsKt.immutableCopy((BlockPos)mutable)), (Block)block).booleanValue()) {
                                    blocks.put(pos, block);
                                }
                                if (z == n3) break;
                                --z;
                            }
                        }
                        if (y == n2) break;
                        --y;
                    }
                }
                if (x == n) break;
                --x;
            }
        }
        return blocks;
    }

    public static /* synthetic */ Map searchBlocks$default(BlockUtils blockUtils, int n, Set set, Integer n2, Function2 function2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            set = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        if ((n3 & 8) != 0) {
            function2 = BlockUtils::searchBlocks$lambda$0;
        }
        return blockUtils.searchBlocks(n, set, n2, function2);
    }

    public final boolean collideBlock(@NotNull AxisAlignedBB axisAlignedBB, @NotNull Function1<? super Block, Boolean> collide) {
        Intrinsics.checkNotNullParameter(axisAlignedBB, "axisAlignedBB");
        Intrinsics.checkNotNullParameter(collide, "collide");
        EntityPlayerSP thePlayer = this.getMc().field_71439_g;
        int y = (int)axisAlignedBB.field_72338_b;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(0, 0, 0);
        int n = (int)thePlayer.func_174813_aQ().field_72336_d + 1;
        for (int x = (int)thePlayer.func_174813_aQ().field_72340_a; x < n; ++x) {
            int n2 = (int)thePlayer.func_174813_aQ().field_72334_f + 1;
            for (int z = (int)thePlayer.func_174813_aQ().field_72339_c; z < n2; ++z) {
                BlockPos.MutableBlockPos blockPos = mutable.func_181079_c(x, y, z);
                Intrinsics.checkNotNull(blockPos);
                Block block = BlockExtensionKt.getBlock((BlockPos)blockPos);
                if (collide.invoke((Block)block).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean collideBlockIntersects(@NotNull AxisAlignedBB axisAlignedBB, @NotNull Function1<? super Block, Boolean> collide) {
        Intrinsics.checkNotNullParameter(axisAlignedBB, "axisAlignedBB");
        Intrinsics.checkNotNullParameter(collide, "collide");
        EntityPlayerSP thePlayer = this.getMc().field_71439_g;
        WorldClient world = this.getMc().field_71441_e;
        int y = (int)axisAlignedBB.field_72338_b;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(0, 0, 0);
        int n = (int)thePlayer.func_174813_aQ().field_72336_d + 1;
        for (int x = (int)thePlayer.func_174813_aQ().field_72340_a; x < n; ++x) {
            int n2 = (int)thePlayer.func_174813_aQ().field_72334_f + 1;
            for (int z = (int)thePlayer.func_174813_aQ().field_72339_c; z < n2; ++z) {
                BlockPos.MutableBlockPos blockPos = mutable.func_181079_c(x, y, z);
                Intrinsics.checkNotNull(blockPos);
                Block block = BlockExtensionKt.getBlock((BlockPos)blockPos);
                if (!collide.invoke((Block)block).booleanValue()) continue;
                IBlockState iBlockState = BlockExtensionKt.getState((BlockPos)blockPos);
                if (iBlockState == null) continue;
                IBlockState it = iBlockState;
                boolean bl = false;
                Block block2 = block;
                AxisAlignedBB axisAlignedBB2 = block2 != null ? block2.func_180640_a((World)world, (BlockPos)blockPos, it) : null;
                iBlockState = axisAlignedBB2;
                if (axisAlignedBB2 == null) {
                    continue;
                }
                IBlockState boundingBox = iBlockState;
                if (!thePlayer.func_174813_aQ().func_72326_a((AxisAlignedBB)boundingBox)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public final Set<Block> getBEDWARS_BLOCKS() {
        return BEDWARS_BLOCKS;
    }

    @NotNull
    public final ResourceLocation getBlockTexture(@NotNull Block block) {
        Intrinsics.checkNotNullParameter(block, "block");
        Block block2 = block;
        return Intrinsics.areEqual(block2, Blocks.field_150324_C) ? new ResourceLocation("minecraft:textures/items/bed.png") : (Intrinsics.areEqual(block2, Blocks.field_150343_Z) ? new ResourceLocation("minecraft:textures/blocks/obsidian.png") : (Intrinsics.areEqual(block2, Blocks.field_150377_bs) ? new ResourceLocation("minecraft:textures/blocks/end_stone.png") : (Intrinsics.areEqual(block2, Blocks.field_150406_ce) ? new ResourceLocation("minecraft:textures/blocks/hardened_clay_stained_white.png") : (Intrinsics.areEqual(block2, Blocks.field_150399_cn) ? new ResourceLocation("minecraft:textures/blocks/glass.png") : (Intrinsics.areEqual(block2, Blocks.field_150355_j) ? new ResourceLocation("minecraft:textures/blocks/water_still.png") : (Intrinsics.areEqual(block2, Blocks.field_150344_f) ? new ResourceLocation("minecraft:textures/blocks/planks_oak.png") : (Intrinsics.areEqual(block2, Blocks.field_150325_L) ? new ResourceLocation("minecraft:textures/blocks/wool_colored_white.png") : new ResourceLocation("minecraft:textures/blocks/stone.png"))))))));
    }

    @Override
    @NotNull
    public Minecraft getMc() {
        return MinecraftInstance.DefaultImpls.getMc(this);
    }

    private static final boolean searchBlocks$lambda$0(BlockPos blockPos, Block block) {
        Intrinsics.checkNotNullParameter(blockPos, "<unused var>");
        Intrinsics.checkNotNullParameter(block, "<unused var>");
        return true;
    }

    static {
        Block[] blockArray = new Block[]{Blocks.field_150325_L, Blocks.field_150406_ce, Blocks.field_150399_cn, Blocks.field_150344_f, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150377_bs, Blocks.field_150343_Z, Blocks.field_150355_j};
        BEDWARS_BLOCKS = SetsKt.setOf(blockArray);
    }
}

