/*
 * Decompiled with CFR 0.152.
 */
package net.ccbluex.liquidbounce.utils.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import net.ccbluex.liquidbounce.injection.implementations.IMixinItemStack;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\t\u001a\u001d\u0010\u0012\u001a\u00020\u0013*\u0004\u0018\u00010\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0001\u001a\u0004\b\u0003\u0010\u0000\u001a\u0014\u0010\u0014\u001a\u00020\u0013*\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u0001\u001a\n\u0010\u001a\u001a\u00020\u0013*\u00020\u0002\u001a\u001b\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0086\u0002\u001a\u0012\u0010!\u001a\u00020\u001d*\u00020\"2\u0006\u0010#\u001a\u00020\u0001\u001a\u0012\u0010$\u001a\u00020\u001d*\u00020\"2\u0006\u0010#\u001a\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"!\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0015\u0010\f\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0004\"\u0015\u0010\u000e\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0004\"\u0015\u0010\u0016\u001a\u00020\u0017*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"durability", "", "Lnet/minecraft/item/ItemStack;", "getDurability", "(Lnet/minecraft/item/ItemStack;)I", "totalDurability", "getTotalDurability", "enchantments", "", "Lnet/minecraft/enchantment/Enchantment;", "getEnchantments", "(Lnet/minecraft/item/ItemStack;)Ljava/util/Map;", "enchantmentCount", "getEnchantmentCount", "enchantmentSum", "getEnchantmentSum", "getEnchantmentLevel", "enchantment", "isEmpty", "", "hasItemAgePassed", "delay", "attackDamage", "", "getAttackDamage", "(Lnet/minecraft/item/ItemStack;)D", "isSplashPotion", "get", "", "Lnet/minecraft/inventory/Slot;", "Lnet/minecraft/inventory/Container;", "range", "Lkotlin/ranges/IntRange;", "inventorySlot", "Lnet/minecraft/entity/player/EntityPlayer;", "slot", "hotBarSlot", "FDPClient"})
@SourceDebugExtension(value={"SMAP\nItemUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemUtils.kt\nnet/ccbluex/liquidbounce/utils/inventory/ItemUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1557#2:162\n1628#2,3:163\n*S KotlinDebug\n*F\n+ 1 ItemUtils.kt\nnet/ccbluex/liquidbounce/utils/inventory/ItemUtilsKt\n*L\n158#1:162\n158#1:163,3\n*E\n"})
public final class ItemUtilsKt {
    public static final int getDurability(@NotNull ItemStack $this$durability) {
        Intrinsics.checkNotNullParameter($this$durability, "<this>");
        return $this$durability.func_77958_k() - $this$durability.func_77952_i();
    }

    public static final int getTotalDurability(@NotNull ItemStack $this$totalDurability) {
        double d2;
        Intrinsics.checkNotNullParameter($this$totalDurability, "<this>");
        if ($this$totalDurability.func_77973_b() instanceof ItemArmor) {
            double d3 = 1.0;
            Enchantment enchantment = Enchantment.field_77347_r;
            Intrinsics.checkNotNullExpressionValue(enchantment, "unbreaking");
            d2 = d3 / (0.6 + 0.4 / (double)(ItemUtilsKt.getEnchantmentLevel($this$totalDurability, enchantment) + 1));
        } else {
            Enchantment enchantment = Enchantment.field_77347_r;
            Intrinsics.checkNotNullExpressionValue(enchantment, "unbreaking");
            d2 = (double)ItemUtilsKt.getEnchantmentLevel($this$totalDurability, enchantment) + 1.0;
        }
        double multiplier = d2;
        return MathKt.roundToInt(multiplier * (double)ItemUtilsKt.getDurability($this$totalDurability));
    }

    @NotNull
    public static final Map<Enchantment, Integer> getEnchantments(@NotNull ItemStack $this$enchantments) {
        Intrinsics.checkNotNullParameter($this$enchantments, "<this>");
        Map enchantments = new LinkedHashMap();
        if ($this$enchantments.func_77986_q() == null || $this$enchantments.func_77986_q().func_82582_d()) {
            return enchantments;
        }
        int n = $this$enchantments.func_77986_q().func_74745_c();
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            NBTTagCompound tagCompound = $this$enchantments.func_77986_q().func_150305_b(it);
            if (!tagCompound.func_74764_b("ench") && !tagCompound.func_74764_b("id")) continue;
            enchantments.put(Enchantment.func_180306_c((int)tagCompound.func_74762_e("id")), tagCompound.func_74762_e("lvl"));
        }
        return enchantments;
    }

    public static final int getEnchantmentCount(@NotNull ItemStack $this$enchantmentCount) {
        Intrinsics.checkNotNullParameter($this$enchantmentCount, "<this>");
        return ItemUtilsKt.getEnchantments($this$enchantmentCount).size();
    }

    public static final int getEnchantmentSum(@NotNull ItemStack $this$enchantmentSum) {
        Intrinsics.checkNotNullParameter($this$enchantmentSum, "<this>");
        return CollectionsKt.sumOfInt((Iterable<Integer>)ItemUtilsKt.getEnchantments($this$enchantmentSum).values());
    }

    public static final int getEnchantmentLevel(@NotNull ItemStack $this$getEnchantmentLevel, @NotNull Enchantment enchantment) {
        Intrinsics.checkNotNullParameter($this$getEnchantmentLevel, "<this>");
        Intrinsics.checkNotNullParameter(enchantment, "enchantment");
        return ((Number)ItemUtilsKt.getEnchantments($this$getEnchantmentLevel).getOrDefault(enchantment, 0)).intValue();
    }

    public static final boolean isEmpty(@Nullable ItemStack $this$isEmpty) {
        return $this$isEmpty == null || $this$isEmpty.func_77973_b() == null;
    }

    public static final boolean hasItemAgePassed(@Nullable ItemStack $this$hasItemAgePassed, int delay) {
        return $this$hasItemAgePassed == null || System.currentTimeMillis() - ((IMixinItemStack)$this$hasItemAgePassed).getItemDelay() >= (long)delay;
    }

    public static final double getAttackDamage(@NotNull ItemStack $this$attackDamage) {
        Intrinsics.checkNotNullParameter($this$attackDamage, "<this>");
        Collection collection = $this$attackDamage.func_111283_C().get((Object)"generic.attackDamage");
        Intrinsics.checkNotNullExpressionValue(collection, "get(...)");
        AttributeModifier attributeModifier = (AttributeModifier)CollectionsKt.firstOrNull(collection);
        double d2 = attributeModifier != null ? attributeModifier.func_111164_d() : 1.0;
        Enchantment enchantment = Enchantment.field_180314_l;
        Intrinsics.checkNotNullExpressionValue(enchantment, "sharpness");
        return d2 + 1.25 * (double)ItemUtilsKt.getEnchantmentLevel($this$attackDamage, enchantment);
    }

    public static final boolean isSplashPotion(@NotNull ItemStack $this$isSplashPotion) {
        Intrinsics.checkNotNullParameter($this$isSplashPotion, "<this>");
        return $this$isSplashPotion.func_77973_b() instanceof ItemPotion && ItemPotion.func_77831_g((int)$this$isSplashPotion.func_77960_j());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Slot> get(@NotNull Container $this$get, @NotNull IntRange range) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$get, "<this>");
        Intrinsics.checkNotNullParameter(range, "range");
        Iterable $this$map$iv = range;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void p0;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean $i$f$get$stub_for_inlining = false;
            boolean bl = false;
            collection.add($this$get.func_75139_a((int)p0));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final Slot inventorySlot(@NotNull EntityPlayer $this$inventorySlot, int slot) {
        Intrinsics.checkNotNullParameter($this$inventorySlot, "<this>");
        Slot slot2 = $this$inventorySlot.field_71069_bz.func_75139_a(slot);
        Intrinsics.checkNotNull(slot2);
        return slot2;
    }

    @NotNull
    public static final Slot hotBarSlot(@NotNull EntityPlayer $this$hotBarSlot, int slot) {
        Intrinsics.checkNotNullParameter($this$hotBarSlot, "<this>");
        return ItemUtilsKt.inventorySlot($this$hotBarSlot, slot + 36);
    }
}

