/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.model;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.fontbox.ttf.model.ScriptFeature;

public class MapBackedScriptFeature
implements ScriptFeature {
    private final String name;
    private final Map<List<Integer>, Integer> featureMap;

    public MapBackedScriptFeature(String name, Map<List<Integer>, Integer> featureMap) {
        this.name = name;
        this.featureMap = featureMap;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<List<Integer>> getAllGlyphIdsForSubstitution() {
        return this.featureMap.keySet();
    }

    @Override
    public boolean canReplaceGlyphs(List<Integer> glyphIds) {
        return this.featureMap.containsKey(glyphIds);
    }

    @Override
    public Integer getReplacementForGlyphs(List<Integer> glyphIds) {
        if (!this.canReplaceGlyphs(glyphIds)) {
            throw new UnsupportedOperationException("The glyphs " + glyphIds + " cannot be replaced");
        }
        return this.featureMap.get(glyphIds);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.featureMap == null ? 0 : this.featureMap.hashCode());
        result2 = 31 * result2 + (this.name == null ? 0 : this.name.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapBackedScriptFeature other = (MapBackedScriptFeature)obj;
        if (this.featureMap == null ? other.featureMap != null : !this.featureMap.equals(other.featureMap)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

