/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.pagenavigation;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.pagenavigation.PDThread;

public class PDThreadBead
implements COSObjectable {
    private final COSDictionary bead;

    public PDThreadBead(COSDictionary b2) {
        this.bead = b2;
    }

    public PDThreadBead() {
        this.bead = new COSDictionary();
        this.bead.setItem(COSName.TYPE, (COSBase)COSName.BEAD);
        this.setNextBead(this);
        this.setPreviousBead(this);
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.bead;
    }

    public PDThread getThread() {
        COSDictionary dic = this.bead.getCOSDictionary(COSName.T);
        return dic != null ? new PDThread(dic) : null;
    }

    public void setThread(PDThread thread2) {
        this.bead.setItem(COSName.T, (COSObjectable)thread2);
    }

    public PDThreadBead getNextBead() {
        return new PDThreadBead(this.bead.getCOSDictionary(COSName.N));
    }

    protected final void setNextBead(PDThreadBead next) {
        this.bead.setItem(COSName.N, (COSObjectable)next);
    }

    public PDThreadBead getPreviousBead() {
        return new PDThreadBead(this.bead.getCOSDictionary(COSName.V));
    }

    protected final void setPreviousBead(PDThreadBead previous) {
        this.bead.setItem(COSName.V, (COSObjectable)previous);
    }

    public void appendBead(PDThreadBead append) {
        PDThreadBead nextBead = this.getNextBead();
        nextBead.setPreviousBead(append);
        append.setNextBead(nextBead);
        this.setNextBead(append);
        append.setPreviousBead(this);
    }

    public PDPage getPage() {
        COSDictionary dic = this.bead.getCOSDictionary(COSName.P);
        return dic != null ? new PDPage(dic) : null;
    }

    public void setPage(PDPage page) {
        this.bead.setItem(COSName.P, (COSObjectable)page);
    }

    public PDRectangle getRectangle() {
        COSArray array = this.bead.getCOSArray(COSName.R);
        return array != null ? new PDRectangle(array) : null;
    }

    public void setRectangle(PDRectangle rect) {
        this.bead.setItem(COSName.R, (COSObjectable)rect);
    }
}

