/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Hex {
    private static final Log LOG = LogFactory.getLog(Hex.class);
    private static final byte[] HEX_BYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private Hex() {
    }

    public static String getString(byte b2) {
        char[] chars = new char[]{HEX_CHARS[Hex.getHighNibble(b2)], HEX_CHARS[Hex.getLowNibble(b2)]};
        return new String(chars);
    }

    public static String getString(byte[] bytes) {
        StringBuilder string = new StringBuilder(bytes.length * 2);
        for (byte b2 : bytes) {
            string.append(HEX_CHARS[Hex.getHighNibble(b2)]).append(HEX_CHARS[Hex.getLowNibble(b2)]);
        }
        return string.toString();
    }

    public static byte[] getBytes(byte b2) {
        return new byte[]{HEX_BYTES[Hex.getHighNibble(b2)], HEX_BYTES[Hex.getLowNibble(b2)]};
    }

    public static byte[] getBytes(byte[] bytes) {
        byte[] asciiBytes = new byte[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            asciiBytes[i * 2] = HEX_BYTES[Hex.getHighNibble(bytes[i])];
            asciiBytes[i * 2 + 1] = HEX_BYTES[Hex.getLowNibble(bytes[i])];
        }
        return asciiBytes;
    }

    public static char[] getChars(short num) {
        char[] hex = new char[]{HEX_CHARS[num >> 12 & 0xF], HEX_CHARS[num >> 8 & 0xF], HEX_CHARS[num >> 4 & 0xF], HEX_CHARS[num & 0xF]};
        return hex;
    }

    public static char[] getCharsUTF16BE(String text) {
        char[] hex = new char[text.length() * 4];
        int charIdx = 0;
        for (int stringIdx = 0; stringIdx < text.length(); ++stringIdx) {
            char c2 = text.charAt(stringIdx);
            hex[charIdx++] = HEX_CHARS[c2 >> 12 & 0xF];
            hex[charIdx++] = HEX_CHARS[c2 >> 8 & 0xF];
            hex[charIdx++] = HEX_CHARS[c2 >> 4 & 0xF];
            hex[charIdx++] = HEX_CHARS[c2 & 0xF];
        }
        return hex;
    }

    public static void writeHexByte(byte b2, OutputStream output) throws IOException {
        output.write(HEX_BYTES[Hex.getHighNibble(b2)]);
        output.write(HEX_BYTES[Hex.getLowNibble(b2)]);
    }

    public static void writeHexBytes(byte[] bytes, OutputStream output) throws IOException {
        for (byte b2 : bytes) {
            Hex.writeHexByte(b2, output);
        }
    }

    private static int getHighNibble(byte b2) {
        return (b2 & 0xF0) >> 4;
    }

    private static int getLowNibble(byte b2) {
        return b2 & 0xF;
    }

    public static byte[] decodeBase64(String base64Value) {
        return Base64.getDecoder().decode(base64Value.replaceAll("\\s", ""));
    }

    public static byte[] decodeHex(String s) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        while (i < s.length() - 1) {
            if (s.charAt(i) == '\n' || s.charAt(i) == '\r') {
                ++i;
                continue;
            }
            String hexByte = s.substring(i, i + 2);
            try {
                baos.write(Integer.parseInt(hexByte, 16));
            }
            catch (NumberFormatException ex) {
                LOG.error((Object)("Can't parse " + hexByte + ", aborting decode"), (Throwable)ex);
                break;
            }
            i += 2;
        }
        return baos.toByteArray();
    }
}

