# 翻译指南

**简体中文** | [English](../en/translateGuide.md)

本文档旨在为将AALC翻译为您的语言提供帮助和指南

共计分为三个部分 (可以点击跳转) :
1. [将文档翻译为您的语言](#文档翻译)
2. [将GUI翻译为您的语言](#gui-翻译)
3. [为AALC提供您喜欢的游戏语言支持 (图片支持)](#图片支持)

若您在翻译过程中有困难或者建议, 欢迎通过 Issues 来获取帮助或反馈

---

## 文档翻译
这一部分的翻译较为简单, 只需要对 Git 和 Github 有所了解即可进行

### 步骤
1. 先对本仓库进行 `fork` 操作
2. 对文档内容进行翻译, 注意不要改动格式
3. 提交您 fork 的仓库并发起 Pull request
4. 等待合并

---
## GUI 翻译
这一部分的翻译需要 Qt 工具的支持, 您需要从 [Qt 官网](https://www.qt.io/download-dev) 下载 `Qt Linguist`, 当然您也可以不使用 `Qt Linguist` , 它只是可以帮助您更好的翻译和编译您的翻译文件 (ts文件) 以供程序使用, 实际上翻译行为只需要一个趁手的编辑器即可完成

如果需要验证翻译结果, 可以使用 `lrelease` 或者 `Qt Linguist` 的编译功能将您的 `.ts` 文件编译成 `.qm` 文件, 需要重命名为 `myapp_en.qm` 并在 AALC 中更改语言为 `English` 方能正确应用

### 步骤
1. 先对本仓库进行 `fork` 操作
2. 找到仓库内名为 `i18n\myapp_en.ts` 的文件, 建议将它的名称更改为 `myapp_yourLanguageCode.ts` , `LanguageCode` 的命名需要遵守国际命名规则, 例如 `zh_TW`
3. 使用 `Qt Linguist` 打开该文件, 对每个词条进行重翻译, 由于原文是中文, 如果您不是很理解可以参考一下英文翻译
4. 将翻译完毕的 `.ts` 文件上传至仓库, 并发起 Pull request
### 特别说明
- 在翻译时如遇到被 `{}` 包含在内的文本请原封不动地保留文本及 `{}` , 这是变量的位置
- 直接使用编辑器翻译的只需要, 也只能更改被囊括在 `<translation>翻译文本</translation>` 内的字符

---

## 图片支持
这一部分的内容需要两种工具: 截图工具和修图工具。您可以使用您自己偏好的工具

### 步骤
1. 依旧是先 `fork` 仓库
2. 根据 `assets\images\zh_cn` 文件夹内的图片和文件结构在游戏内截图
3. 截图后使用修图工具把目标位置以外的像素涂黑 **(RGB: 0,0,0 / #000)**
4. 保存图片, 并注意名称一致
5. 将图片提交至仓库后, 发起 Pull request

### 注意事项
- 原图片的尺寸与您的图片尺寸建议一致, 若原图不是完整图片可以酌情改变
- **建议自行运行几遍**来确保您的图片能够正确识别
- 若您开启了 *(实验性功能) 自动切换语言* 可以在设置界面下方关闭, 随后可以测试您的图片是否能够使用
- **我们不会也无力替您维护您的图片资源。 Limbus Company 很可能会频繁改动游戏内 UI , 届时请您自行更改图片**