/*********************************************************************************************************
* ģ: PolynomialFit.c
* ժ    Ҫ: ʽ
* ǰ汾: 1.0.0
*     : SZLY(COPYRIGHT 2019 SZLY. All rights reserved.)
* : 20190801
*     : 
* ע    : 
**********************************************************************************************************
* ȡ汾: 
*     : 
* : 
* ޸: 
* ޸ļ: 
*********************************************************************************************************/

/*********************************************************************************************************
*                                              ͷļ
*********************************************************************************************************/
#include "PolynomialFit.h"
#include "stdio.h"
#include <math.h>

/*********************************************************************************************************
*                                              궨
*********************************************************************************************************/
#define OLDER_MAX 10  //̫󣬷SRAMû㹻ڴʹ
#define ACCURACY 10    //

#define ROW 8
#define COLUMN 9
/*********************************************************************************************************
*                                              öٽṹ嶨
*********************************************************************************************************/

/*********************************************************************************************************
*                                              ڲ
*********************************************************************************************************/
double b[15];
double zz[ROW][COLUMN] = {0};
double fz[ROW] = { 0 };
/*********************************************************************************************************
*                                              ڲ
*********************************************************************************************************/

/*********************************************************************************************************
*                                              ڲʵ
*********************************************************************************************************/

/*********************************************************************************************************
*                                              APIʵ
*********************************************************************************************************/
/*********************************************************************************************************
* : CalcPolynomial
* : ʽ
* : a-ʽϵx-Աolder-ʽ
* : void
*   ֵ: void
* : 20180101
* ע		:
*********************************************************************************************************/
double CalcPolynomial(double* a, double x, unsigned char older)
{
  double result = 0;
  int i = 0;
  b[0] = 1;
  //xN
  for (i = 1; i <= older; i++)
  {
    b[i] = b[i - 1] * x;
  }

  //ʽ
  for (i = 0; i <= older; i++)
  {
    result += a[i] * b[i];
  }

  return result;
}

/*********************************************************************************************************
* : CalcPolyIntegral
* : ʽ
* : a-ʽϵx1x2-older-ʽ
* : void
*   ֵ: void
* : 20180101
* ע		: ֧199
*********************************************************************************************************/
double CalcPolyIntegral(double* a, double x1, double x2, unsigned char older)
{
  double i = 0;
  double y1;
  double y2;
  double result;

  //ԭϵ
  b[0] = 0;
  for (i = 1; i <= (double)older + 1; i = i + 1)
  {
    b[(int)i] = a[(int)(i - 1)] / i;
  }

  //
  y1 = CalcPolynomial(b, x1, older + 1);
  y2 = CalcPolynomial(b, x2, older + 1);
  result = y2 - y1;

  return result;
}

/*********************************************************************************************************
* : FindMaxInPolynomial
* : Ҷʽֵλ
* : a-ʽϵx1x2-older-ʽgap-Ҽ
* : void
*   ֵ: void
* : 20180101
* ע		: 
*********************************************************************************************************/
double FindMaxInPolynomial(double* a, double x1, double x2, unsigned char older, double gap)
{
  double maxIndex = 0;  //ֵλ
  double maxOld = 0;
  double maxNew = 0;
  double i = 0;
  double temp;

  //С
  if (x1 > x2)
  {
    temp = x1;
    x1 = x2,
      x2 = temp;
  }

  for (i = x1; i <= x2; i = i + gap)
  {
    maxNew = CalcPolynomial(a, i, older);

    //ֵ
    if (maxNew > maxOld)
    {
      maxOld = maxNew;
      maxIndex = i;
    }
  }
  
  return maxIndex;
}

/*********************************************************************************************************
* : FindFirstMaxInPolynomial
* : ߵһֵ
* : a-ʽϵx1x2-older-ʽgap-ʼλ
* : void
*   ֵ: void
* : 20180101
* ע		:
*********************************************************************************************************/
double FindFirstMaxInPolynomial(double* a, double x1, double x2, unsigned char older, double gap)
{
  double i = 0;
  double temp;

  double pre, now, next;

  //С
  if (x1 > x2)
  {
    temp = x1;
    x1 = x2,
    x2 = temp;
  }

  for (i = x1 + gap; i <= x2; i = i + gap)
  {
	pre = CalcPolynomial(a, i-gap, older);
	now = CalcPolynomial(a, i, older);
	next = CalcPolynomial(a, i + gap, older);
//	printf("\r\n");
//	printf("i = %f maxNew = %f\r\n", i,now);
	if (now > pre && now > next)
	{
		break;
	}
  }
  return i;
}
/*********************************************************************************************************
* : Polynomia_y_to_x
* : 
* : a-ʽϵx1-߽磬x2-ұ߽磬older-ʽy,gap-pre-Χ
* : void
*   ֵ: x
* : 20180101
* ע		: outPutÿ֮ǰoutPutӦʼΪ0ϻ쳣
*********************************************************************************************************/
double Polynomia_y_to_x(double* a, float x1, float x2,unsigned char older,double y,float gap,float pre)
{
  double i = 0;
  double temp_x;
  
  if (x1 < x2)
  {
    for (i = x1; i <= x2; i = i + gap)
    {
      if(CalcPolynomial(a, i, older) >= y - pre && CalcPolynomial(a, i, older)<= y + pre)
      {
        break;
      }
    }
  }
  else
  {
    for (i = x1; i >= x2; i = i - gap)
    {
      if(CalcPolynomial(a, i, older) >= y - pre && CalcPolynomial(a, i, older)<= y + pre)
      {
        break;
      }
    }
  }
  
  return i;
}

/*********************************************************************************************************
* : PolynomialFit
* : С˷϶ʽ
* : x-Ա
*           y-
*           outPut-ϵ
*           maxn-
*           older-Ͻ
* : void
*   ֵ: void
* : 20180101
* ע		: outPutÿ֮ǰoutPutӦʼΪ0ϻ쳣
*********************************************************************************************************/
void PolynomialFit(double* x, double* y, double* output, int maxn, unsigned char older)
{
  int i;
	int j;
	int k;
	int n;
	double temp = 0;
  
  double m = 0;
	double max = 0;
	int m_max;
  
  int s_row = older+1;
  int s_col = older+2;
  
  //ջ
  for(i = 0;i<ROW;i++)
  {
    fz[i] = 0;
    for(j = 0;j<COLUMN;j++)
    {
      zz[i][j] = 0;
    }
  }
  //
	for (i = 0; i < maxn; i++)
	{
		for (j = 0; j < s_row; j++)
		{
			for (k = 0; k < s_row; k++)
			{
				temp = 1;
				for (n = 0; n < j + k; n++)
				{
					temp = temp*x[i];
				}
				zz[j][k] += temp;
			}
			temp = y[i];
			for (n = 0; n < j; n++)
			{
				temp = temp * x[i];
			}
			fz[j] += temp;
		}
	}
	for (j = 0; j < s_row; j++)
	{
		zz[j][s_col-1] = fz[j];
	}
  
  //Ұб
	for (j = 0; j < s_col - 2; j++)
	{
		//ѰԪأϵ£бģ
		max = zz[j][j];
		m_max = 0;
		for (k = j; k < s_row; k++)
		{
			if (zz[k][j] > max)
			{
				max = zz[k][j];
				m_max = k;//¼
			}
		}
		//,(б)
		for (k = 0; k < s_col; k++)
		{
			temp = zz[m_max][k];
			zz[m_max][k] = zz[j][k];
			zz[j][k] = temp;
		}
		//ϵ£ȥ
		for (i = j + 1; i <  s_row; i++)
		{
			
			m = zz[i][j] / zz[j][j];
			for (k = j; k < s_col; k++)
			{
				zz[i][k] = zz[i][k] - m * zz[j][k];
			}
		}
	}
  
  //ش
	//
	for (i = s_row - 1; i >= 0; i--)
	{
		temp = zz[i][s_col-1];
		for (j = s_col - 2; j > i;j--)
		{
			temp -= zz[i][j] * output[j];
		}
		output[j] = temp / zz[i][j];
	}
  
  printf("\r\n");
	printf("work\r\n");
	for (i = 0; i < s_row; i++)
	{
		printf("%+f.*x.^%d", output[i], i);
	}
  printf("\r\n");
}

///*********************************************************************************************************
//* : GaussianFit
//* : ˹
//* : x-Ա
//*           y-
//*           maxn-
//*           x_max-ֵ
//*           y_max-ֵ
//*           s-ֵ
//* : void
//*   ֵ: void
//* : 20180101
//* ע		: outPutÿ֮ǰoutPutӦʼΪ0ϻ쳣
//*********************************************************************************************************/
//void GaussianFit(double* x, double* y,int maxn,double* x_max,double* y_max,double* s)
//{
//  double coofe[3] = { 0 };//
//  double y_log[maxn];
//  for (int j = 0; j < maxn; j++)
//	{
//		y_log[j] = log(y[j]);
//	}

//	PolynomialFit(x, y_log, coofe, maxn, 2);
//	
//	*s = -1/coofe[2];
//	*x_max = coofe[1] * (*s) / 2;
//	*y_max = exp(coofe[0] + (*x_max) * (*x_max) / (*s));
//}

