/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support;

import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.Function;
import javax.annotation.Nullable;

public class AnnotationReflectionHelper {
    private AnnotationReflectionHelper() {
    }

    @Nullable
    public static Class<? extends Annotation> forNameOrNull(ClassLoader classLoader, String className) {
        try {
            return Class.forName(className, true, classLoader).asSubclass(Annotation.class);
        }
        catch (ClassCastException | ClassNotFoundException exception) {
            return null;
        }
    }

    public static <A extends Annotation, T> Function<A, T> bindAnnotationElementMethod(MethodHandles.Lookup lookup, Class<? extends Annotation> annotationClass, String methodName, Class<T> returnClass) throws Throwable {
        MethodHandle valueHandle = lookup.findVirtual(annotationClass, methodName, MethodType.methodType(returnClass));
        CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), valueHandle, MethodType.methodType(returnClass, annotationClass));
        MethodHandle factory = callSite.getTarget();
        Function function = factory.invoke();
        return function;
    }
}

