# 更新日志

所有值得注意的项目更改将记录在此文件中。

格式基于[保持更新日志](https://keepachangelog.com/zh-CN/1.0.0/)，
本项目遵循[语义化版本](https://semver.org/lang/zh-CN/)。

## [1.2.6] - 2025-09-13

### 🔧 文件提交修复
- **修复 .gitignore 规则** - 将 `.claude/` 改为 `/.claude/`，只忽略根目录的配置文件
- **添加缺失的 mcp-status.md** - 补充提交 `/mcp-status` 命令模板文件

### 📋 技术说明
- 之前 `.gitignore` 中的 `.claude/` 规则意外忽略了 `templates/.claude/` 目录
- 导致 `mcp-status.md` 等模板文件未被提交到远程仓库
- 现在修正为只忽略项目根目录的 `.claude/` 用户配置目录

## [1.2.5] - 2025-09-13

### 🔧 重要修复
- **setup.sh 默认配置优化** - 移除用户询问，默认安装所有 MCP 服务器
- **MCP 服务器配置修正** - 使用正确的 `gemini-mcp-tool` 包名和服务名
- **恢复 MCP 服务器配置生成** - setup.sh 现在正确生成 `settings.local.json` 中的 MCP 配置

### 📝 文档纠正
- **README.md 命令列表修正** - 移除虚假的命令，替换为实际存在的斜杠命令
- **命令描述准确化** - 明确说明是在 Claude Code 中使用的斜杠命令，不是终端命令

### 🛠️ 安装体验改进  
- **简化安装流程** - 不再询问用户选择，直接安装所有功能
- **MCP 配置一致性** - 确保配置文件与实际包名保持一致

### ⚡ 技术优化
- **配置生成逻辑优化** - 简化脚本逻辑，提高安装成功率
- **服务器命名规范** - 统一使用正确的 MCP 扩展名称

## [1.2.4] - 2025-09-12

### 🔧 问题修复
- **修复 MCP 安装命令语法** - 更新安装脚本中的 MCP 命令为正确语法
- **Gemini MCP 仓库修复** - 修正 Gemini MCP 仓库 URL 和安装命令

### ✨ 新增功能  
- **技术专家代理系统** - 新增 5 个专业技术专家代理，提升专业咨询能力
- **智浦 AI 引擎支持** - 添加智浦 AI 引擎介绍到 README
- **核心命令汉化** - 完全汉化 templates/.claude/commands/ 目录下的核心 Markdown 文件

### 📝 文档改进
- **中文化增强** - 提升命令文档的中文本土化体验
- **AI 引擎扩展** - 丰富 AI 引擎选择和说明

### 🛠️ 技术优化
- **安装流程改进** - 优化 MCP 服务器安装的稳定性和准确性
- **代理系统架构** - 建立更完善的专家代理分工体系

## [1.2.3] - 2025-08-30

### 🔧 问题修复
- **修复 MCP 服务器包名错误** - Context7 使用正确包名 @upstash/context7-mcp
- **替换无效 Gemini MCP 服务器** - 使用可用的 gemini-mcp 包
- **添加 API 密钥配置支持** - MCP 服务器配置中包含 API 密钥占位符

### 📝 用户体验改进
- **完善配置提醒信息** - 安装后明确提示用户需要配置 API 密钥
- **详细配置指导** - 提供具体的配置文件编辑说明

### 🔒 配置优化
- **API 密钥占位符** - 设置明确的占位符提醒用户配置真实密钥
- **配置文件结构修正** - 确保 MCP 服务器配置格式正确

## [1.2.2] - 2025-08-29

### ✨ 新增功能
- **AnyRouter 赞助商支持** - README 头部添加赞助商感谢区域
- **免费转发节点介绍** - 准确描述 AnyRouter 为中国开发者提供的免翻墙 Claude Code 转发服务

### 📝 文档优化
- **热情文案** - 用更热情洋溢的语言介绍 Claude Code 编程体验
- **价值突出** - 强调免费服务和无需翻墙的便利性

## [1.2.1] - 2025-08-29

### 🔧 问题修复
- **CLAUDE.md 文件处理修复** - 恢复被误删的开发配置文件
- **正确屏蔽机制** - 通过 .gitignore 屏蔽而非删除 CLAUDE.md
- **.gitignore 优化** - 添加分类注释，使配置更清晰

### 📋 技术说明
- CLAUDE.md 应存在于项目根目录为用户提供完整 AI 开发体验
- 通过 .gitignore 防止开发配置提交到仓库
- 维护开发配置和分发包的正确分离

## [1.2.0] - 2025-08-29

### 📁 项目结构优化
- **清理开发文件** - 移除不必要的开发配置文件
- **简化命名** - 安装脚本优化为 install.sh
- **目录整理** - 优化 .gitignore，排除开发目录

### 📚 文档增强
- **README 徽章** - 增加专业徽章展示
- **布局优化** - 居中导航布局优化
- **时间校正** - 修正所有文档中的时间戳为 2025

### 🛠️ 安装体验
- **MCP 功能完整** - 保持完整的 MCP 服务器配置功能
- **一键安装** - 安装命令更简洁直观

## [1.1.0] - 2025-08-29

### 🔧 重大修复
- **修复 MCP 服务器配置缺失问题** - 安装后现在正确包含 MCP 功能
- **添加交互式 MCP 配置** - 用户可选择安装 Context7 和 Gemini MCP 服务器
- **动态生成 settings.local.json** - 根据用户选择生成正确配置

### ✨ 新增功能
- **完整 MCP 服务器支持** - Context7 文档查询和 Gemini 深度咨询
- **智能配置生成** - 自动配置 MCP 服务器和 Hook 脚本
- **非交互模式支持** - 管道安装时自动启用推荐功能

### 🎯 用户体验改进
- **中文交互界面** - 完全中文化的配置选择过程
- **智能默认选择** - 推荐启用所有MCP功能
- **详细功能说明** - 每个组件都有清晰的中文说明

### 🔒 安全增强  
- **MCP 安全扫描** - 自动检测MCP调用中的潜在安全风险
- **敏感数据保护** - 防止API密钥等敏感信息泄露

### 💡 开发者功能
- **mcp__gemini__consult_gemini** - 启用 Gemini 架构咨询功能
- **mcp__context7__get_library_docs** - 获取最新外部库文档
- **自动上下文注入** - Gemini咨询自动附加项目文档

## [1.0.0] - 2025-08-29

### 🎉 首次发布
- Claude Code 中文开发套件正式发布
- 完全中文化的安装和使用体验

### ✨ 新增功能
- **一键安装脚本** (`install-cn.sh`) - 完全中文化的安装体验
- **智能项目配置** (`setup.sh`) - 自动配置Claude Code环境
- **三层文档架构** - 完整的中文文档系统
  - 第1层：基础文档 (CLAUDE.md, project-structure.md)
  - 第2层：组件文档 (CONTEXT-tier2-component.md)
  - 第3层：功能文档 (CONTEXT-tier3-feature.md)

### 🔧 核心组件
- **中文 AI 上下文** - 完全中文化的 CLAUDE.md 模板
- **MCP 助手规则** - 中文版 MCP-ASSISTANT-RULES.md
- **Hook 脚本系统** - 自动化上下文注入和安全扫描
  - `subagent-context-injector.sh` - 子智能体上下文自动注入
  - `gemini-context-injector.sh` - Gemini 咨询文档自动附加
  - `mcp-security-scan.sh` - MCP 调用安全扫描
  - `notify.sh` - 系统事件通知

### 📚 完整命令集
- `/code-review` - 代码审查命令
- `/create-docs` - 文档生成命令  
- `/gemini-consult` - Gemini 深度咨询
- `/full-context` - 完整上下文加载
- `/handoff` - 任务交接管理
- `/refactor` - 代码重构命令
- `/update-docs` - 文档更新命令

### 🎯 中文化特色
- **零门槛安装** - 一行命令完成所有设置
- **完全中文界面** - 从安装到使用全程中文
- **中文文档模板** - 适合中文开发者的文档结构
- **本土化适应** - 符合中文开发者习惯的配置

### 🔒 安全特性
- **敏感数据扫描** - 防止意外泄露API密钥和密码
- **智能文件过滤** - 自动排除敏感配置文件
- **安全事件记录** - 完整的安全日志系统

### 📦 技术实现
- **与原版100%兼容** - 基于 Claude Code Development Kit 架构
- **智能文件复制** - 不覆盖现有配置的安全安装
- **跨平台支持** - macOS、Linux、Windows 全平台支持
- **错误处理** - 完整的错误检测和用户友好提示

### 🌟 开源贡献
- **MIT 协议** - 完全开源，自由使用和修改
- **社区驱动** - 欢迎中文开发者社区贡献
- **文档完整** - 详细的使用指南和开发文档

---

## [未来计划]

### 🚀 计划中的功能
- **项目模板库** - 更多编程语言的项目模板
- **中文文档生成** - AI 自动生成中文技术文档
- **团队协作增强** - 多人协作的中文化工作流
- **集成更多AI服务** - 支持更多中文AI服务商

### 💡 贡献指南
欢迎通过以下方式贡献：
- 提交 Issue 报告问题或建议功能
- 提交 Pull Request 贡献代码或文档
- 分享使用经验和最佳实践
- 帮助推广项目到中文开发者社区

---

*基于 [Claude Code Development Kit](https://github.com/peterkrueck/Claude-Code-Development-Kit) 项目*