## 快速参考卡片

> **🔥 协同技巧**：这些快速参考在组合使用时效果最佳。示例：使用后台任务 + 状态行 + 子代理实现终极生产力。

[↑ 返回顶部](#快速导航)

### 即时命令参考
```bash
# 后台任务（新功能 - 实现正在演进）
npm run dev &                    # 在后台运行
[注意：以下命令来自公告，请验证可用性]
/bashes                          # 列出后台进程（需验证）
/bash-output <id>                # 检查输出（需验证）
/kill-bash <id>                  # 停止进程（需验证）

# 状态行（新功能）
/statusline git branch           # 显示git分支
/statusline "📍 $(pwd)"          # 显示当前目录
/statusline custom               # 自定义状态

# 安全
[注意：/security-review 是自定义命令示例，非内置命令]
# 创建您自己的：~/.claude/commands/security-review.md

# 子代理（官方）
/agents                          # 管理子代理（官方）
@code-reviewer fix this          # 直接代理提及（根据公告）
@architect design auth           # 调用特定代理（根据公告）

# 上下文管理
/compact "focus on auth"         # 压缩对话（官方）
/add-dir ../other-project        # 添加工作目录（官方）
[注意：/microcompact 在公告中提到但不在文档中]

# 基本命令（官方）
/help                            # 显示所有命令
/clear                           # 清除对话  
/model                           # 切换AI模型
/review                          # 请求代码审查
/compact                         # 压缩对话
/init                           # 初始化 CLAUDE.md
/memory                         # 编辑内存文件
```

### 功能快速参考
```bash
# 后台任务
→ 长时间运行：开发服务器、测试、构建
→ 实时监控：日志、错误、输出
→ 自动恢复：Claude可以修复崩溃

# 多目录
→ Monorepo：跨包工作
→ 共享配置：从任何地方访问
→ 跨项目：轻松迁移代码

# PDF支持
→ 直接阅读：无需转换
→ 用例：规范、文档、研究论文
→ 引用：@document.pdf

# 安全审查
→ 漏洞：SQL注入、XSS、数据泄露
→ GitHub Actions：自动PR审查
→ 修复：Claude可以修复发现的问题
```

### 高级用户快捷键
```bash
# 并行后台任务
npm run dev & npm run test:watch & npm run storybook &

# 智能调试
"服务器崩溃" → Claude 检查后台日志 → 自动修复

# 子代理团队
@architect @reviewer @tester "审查身份验证实现"

# 上下文优化
长会话 → /microcompact → 继续工作
切换焦点 → /compact "新功能" → 全新上下文

# 多仓库工作流
/add-dir ../api-server
/add-dir ../frontend
"跨项目同步API类型"
```

### 任务状态参考
```bash
# 后台进程状态
RUNNING   → 活跃进程
COMPLETED → 成功完成
FAILED    → 崩溃（Claude可以调试）
KILLED    → 手动停止

# 上下文状态（近似）
FRESH     → 会话早期
OPTIMAL   → 良好工作状态
FULL      → 变得冗长
CRITICAL  → 缓慢（使用 /microcompact）

# 代理活动
IDLE      → 等待任务
ACTIVE    → 处理请求
BLOCKED   → 需要用户输入
COMPLETE  → 任务完成
```

### 常见工作流程卡片
```bash
# 开始开发会话
1. npm run dev &                  # 在后台启动
2. /statusline "🚀 开发模式"     # 设置状态
3. /add-dir ../shared            # 添加共享配置
4. "修复登录错误"               # Claude 监控日志

# 安全优先开发
1. "实现用户输入"               # 构建功能
2. /security-review              # 检查漏洞
3. "修复XSS问题"                # 解决发现的问题
4. git commit                    # 安全代码

# 多代理审查
1. "构建身份验证系统"           # 初始实现
2. @architect "审查设计"        # 架构检查
3. @security "检查漏洞"          # 安全审计
4. @tester "编写测试"           # 测试覆盖

# 长会话管理
1. 工作数小时                   # 上下文累积
2. /microcompact                # 清除旧调用
3. 无缝继续                     # 继续工作
4. 切换时使用 /compact          # 如需完全重置
```

## 核心概念（从此开始）

> **🧑‍💻 从这里开始**：Claude Code 新手？从[核心能力](#核心-claude-code-能力)开始，然后探索[权限模型](#权限模型)，并设置您的第一个[CLAUDE.md](#项目上下文-claudemd)。

[↑ 返回顶部](#快速导航)

### 核心 Claude Code 能力
Claude Code 通过自然对话和直接操作工作：

```bash
# Claude Code 的功能：
- 从纯英语描述构建功能
- 通过分析代码库调试和修复问题
- 导航和理解整个项目结构
- 自动化常见开发任务
- 直接编辑文件和运行命令

# 核心能力：
功能构建 → "创建用户身份验证系统"
→ 分析需求，创建计划，编写代码

调试 → "修复支付处理错误"
→ 调查日志，追踪问题，实施修复

代码库分析 → "审查此代码的安全问题"
→ 检查代码，识别漏洞，建议改进

自动化 → "修复项目中的所有lint问题"
→ 识别问题，自动应用修复

# 工作原理：
- 终端中的直接对话
- 可以直接编辑文件
- 根据需要运行命令
- 创建提交并管理git
- 维护项目上下文
- 支持外部集成（MCP）

# 集成功能：
- 自动化钩子
- 工作流斜杠命令
- 编程使用SDK
- 专业任务子代理
- IDE集成
```

**关键理解**：Claude Code 通过自然语言交互工作，根据您的请求直接编辑文件和运行命令。不需要特殊语法——只需描述您的需求。

### 多模态能力
智能处理不同类型的内容：

```bash
# 文本/代码文件
- 阅读和分析任何编程语言
- 理解上下文和模式
- 生成适当的解决方案

# 图像
- 截图：读取UI、错误、设计
- 图表：理解架构、流程
- 图表：解释数据和趋势
- 照片：提取相关信息

# 文档
- PDF：直接读取技术文档
- 表格：解析结构化数据
- 演示文稿：提取内容和要点

# 组合分析
- 代码 + 图表：理解实现和设计
- 文档 + 代码：验证实现符合规范
- 多文件：跨项目模式识别
```

### 1. 核心能力

#### 信息处理
```bash
# Claude Code 可以处理的信息类型：
代码文件 → 语法分析、模式识别、优化建议
文档 → 内容提取、关键信息总结
配置文件 → 验证、最佳实践推荐
日志文件 → 错误模式识别、问题诊断
图像 → UI分析、设计理解、图表解释

# 处理深度：
表面层 → 语法和结构分析
中间层 → 逻辑和流程理解
深层 → 模式识别和最佳实践应用
```

#### 任务管理
```bash
# 任务分解和跟踪：
复杂任务 → 自动分解为可管理的步骤
依赖关系 → 识别和处理任务依赖
进度跟踪 → 实时状态更新和完成度
质量控制 → 每个步骤的验证和测试

# 协作功能：
团队协调 → 多代理协作和任务分配
知识共享 → 跨会话学习和模式应用
自动化 → 重复任务的自动化处理
```

#### 执行模式
```bash
# 开发模式：
功能开发 → 从描述到实现
调试修复 → 问题识别和解决
代码审查 → 质量检查和改进
文档生成 → 自动文档创建

# 优化模式：
性能优化 → 速度和效率改进
安全增强 → 漏洞检测和修复
代码重构 → 结构和质量改进
资源优化 → 内存和CPU使用优化
```

### 2. 权限模型

#### 权限流程
```bash
# Claude Code 的安全方法：
验证 → 确认操作的安全性和适当性
授权 → 检查用户权限和项目约束
执行 → 安全地执行批准的操作
监控 → 持续监控和风险评估

# 安全层级：
系统级 → 文件系统权限和进程管理
项目级 → 项目特定约束和规则
用户级 → 个人偏好和历史模式
```

#### 信任建立模式
```bash
# 建立信任的方法：
透明操作 → 所有操作的清晰日志
验证检查 → 变更前后的验证
增量方法 → 小步骤，持续验证
学习适应 → 基于反馈改进决策

# 风险缓解：
安全沙箱 → 隔离执行环境
备份系统 → 变更前自动备份
回滚能力 → 快速恢复到之前状态
```

### 3. 项目上下文（CLAUDE.md）

#### CLAUDE.md 中期望的内容
```bash
# 项目信息：
项目描述 → 目标、范围、目标受众
技术栈 → 语言、框架、工具、库
架构 → 系统设计、组件关系
约束 → 限制、要求、依赖关系

# 开发信息：
编码标准 → 样式指南、最佳实践
测试方法 → 测试框架、覆盖率要求
部署流程 → 环境、步骤、验证
维护指南 → 常见任务、故障排除

# 上下文信息：
当前状态 → 进行中的工作、已知问题
决策日志 → 重要选择及其原因
模式库 → 成功的解决方案和模式
学习记录 → 经验教训和改进
```

### 内存管理和 CLAUDE.md 更新

#### 智能内存更新模式
```bash
# 自动更新触发器：
重要变更 → 功能完成、架构决策
问题解决 → 调试会话、修复实现
模式识别 → 重复解决方案、最佳实践
项目演进 → 新依赖、技术栈更改

# 更新内容：
新信息 → 当前工作、学习模式
验证 → 现有信息的准确性验证
整合 → 新知识与现有上下文的合并
优化 → 信息组织和可访问性改进
```

#### 内存质量验证
```bash
# 验证检查：
准确性 → 信息与项目状态的一致性
完整性 → 所有相关信息的包含
相关性 → 保留重要且相关的信息
组织性 → 逻辑结构和易于访问

# 质量指标：
信息新鲜度 → 最近更新的频率
使用频率 → 信息的访问和实用性
模式有效性 → 学习模式的成功应用
```

### 自动化内存管理模式

#### 内存更新工作流
```bash
# 更新工作流程：
1. 重要变更检测 → 自动识别显著事件
2. 信息提取 → 从交互中提取关键洞察
3. 验证检查 → 确保准确性和相关性
4. 集成更新 → 无缝合并到现有内存
5. 质量评估 → 验证更新内存的质量
```

#### 重要工作后触发
```bash
# 触发事件：
功能完成 → 主要功能或组件实现
问题解决 → 复杂错误或问题修复
架构决策 → 系统设计或结构更改
学习事件 → 新模式或最佳实践发现

# 自动化处理：
变更捕获 → 记录变更的详细信息
影响分析 → 评估变更对项目的影响
知识提取 → 识别可重用的模式和洞察
内存更新 → 将新知识整合到项目内存中
```

#### 质量验证
```bash
# 验证步骤：
一致性检查 → 确保信息一致性
完整性验证 → 确认所有相关信息存在
准确性确认 → 验证事实和技术细节
相关性评估 → 确保保留的信息相关且有用

# 持续改进：
使用监控 → 跟踪内存信息的有效性
反馈整合 → 从用户交互中学习
模式优化 → 改进信息组织和检索
```

### 内存管理模式

#### 常见内存操作
```bash
# 核心操作：
信息存储 → 保存相关项目信息
模式识别 → 识别和存储成功模式
知识检索 → 快速访问相关信息
上下文维护 → 保持项目状态最新

# 高级操作：
跨项目学习 → 在项目间应用知识
预测性建议 → 基于历史模式提供洞察
质量保证 → 验证存储信息的准确性
```

### CLAUDE.md 模板以优化召回

#### 项目模板结构
```markdown
# 项目：[名称]

## 🔴 关键上下文（首先阅读）
- 项目目标和范围
- 关键技术和架构决策
- 当前状态和进行中的工作
- 已知约束和限制

## 有效的命令
- 常用命令及其用途
- 项目特定的脚本和工具
- 开发和部署命令

## 遵循的模式
- 编码标准和最佳实践
- 架构模式和设计原则
- 测试方法和质量保证
- 工作流程和过程

## ⚠️ 陷阱和不应做的事情
- 常见错误和问题
- 反模式和避免的做法
- 技术债务和已知问题
- 安全考虑和限制

## 文件结构模式
- 项目组织结构
- 组件和模块模式
- 配置文件和设置
- 文档和资源位置

## 最近学习
- 新发现的模式和实践
- 问题解决方案和教训
- 优化和改进
- 团队洞察和反馈

## 4. ROADMAP.md 项目管理

#### 项目路线图
```markdown
# 总体目标
- 项目愿景和目标
- 成功标准和指标
- 时间表和里程碑
- 资源和约束

# 关键功能
- 功能优先级和依赖关系
- 实施计划和时间表
- 风险和缓解策略
- 质量保证措施
```

#### 当前冲刺（第 X-Y 周）
```markdown
# 本周目标
- 具体目标和可交付成果
- 进行中的任务和状态
- 阻挡问题和挑战
- 所需资源和支持

# 任务分配
- 团队成员和责任
- 技能要求和匹配
- 协作和沟通计划
- 进度跟踪和报告
```

#### 即将优先事项
```markdown
# 下一步计划
- 即将到来的功能和任务
- 依赖关系和先决条件
- 时间估计和资源需求
- 风险评估和缓解

# 中期目标
- 季度和年度目标
- 重大里程碑和交付成果
- 战略计划和调整
- 绩效指标和评估
```

#### 最近完成
```markdown
# 完成的工作
- 已完成的任务和功能
- 实现的目标和里程碑
- 质量指标和结果
- 经验教训和改进

# 成就庆祝
- 团队成就和认可
- 创新和创造性解决方案
- 持续改进和优化
- 客户和用户反馈
```

#### 技术债务
```markdown
# 已识别问题
- 代码质量和维护问题
- 性能瓶颈和优化机会
- 安全漏洞和风险
- 文档和知识差距

# 优先级和计划
- 修复优先级和时间表
- 资源分配和责任
- 质量保证措施
- 长期维护策略
```

### 5. 上下文和会话管理

#### 上下文管理模式
```bash
# 上下文类型：
项目上下文 → 技术栈、架构、约束
会话上下文 → 当前任务、最近操作、短期目标
历史上下文 → 过去决策、模式、学习
用户上下文 → 偏好、技能、工作风格

# 管理策略：
压缩 → 移除冗余，保留关键信息
分层 → 按重要性组织信息
优化 → 根据当前需求调整内容
演进 → 随项目发展更新上下文
```

#### 上下文优化技术
```bash
# 压缩策略：
语义压缩 → 保留含义，减少冗余
模式提取 → 识别和存储可重用模式
重要性加权 → 基于相关性优先排序信息
智能分层 → 按访问频率组织信息

# 优化触发器：
令牌限制 → 当接近上下文限制时
会话转换 → 当切换任务或焦点时
质量下降 → 当性能受影响时
用户请求 → 当明确要求优化时
```

### 6. 后台任务和实时监控（新功能）

#### 后台执行模式
```bash
# 后台任务类型：
开发服务器 → 长时间运行的开发环境
测试执行 → 自动化测试和验证
构建过程 → 代码构建和打包
数据监控 → 日志分析和性能跟踪

# 管理命令：
进程启动 → npm run dev & (后台运行)
进程列表 → /bashes (列出所有后台进程)
输出检查 → /bash-output <id> (查看进程输出)
进程终止 → /kill-bash <id> (停止后台进程)
```

#### 监控和管理
```bash
# 监控功能：
实时监控 → 进程状态和输出跟踪
错误检测 → 自动识别和报告问题
性能跟踪 → 资源使用和性能指标
警报系统 → 重大问题的即时通知

# 管理操作：
进程控制 → 启动、停止、重启进程
资源分配 → CPU和内存使用管理
日志管理 → 日志收集、分析和存储
报告生成 → 状态和性能报告
```

#### 实时调试
```bash
# 调试能力：
错误分析 → 自动错误诊断和建议
性能分析 → 瓶颈识别和优化建议
日志监控 → 实时日志分析和模式识别
问题解决 → 自动修复和恢复建议

# 监控 + 开发：
开发 + 监控 → Claude 同时监控两者
可以在不停止另一个的情况下修复任一问题
自动错误恢复 → Claude 聚合结果并修复问题
```

#### 并行验证
```bash
# 多进程验证：
所有检查同时运行 → 并行执行多个验证任务
结果聚合 → Claude 聚合所有结果
智能修复 → 基于聚合结果应用修复
质量保证 → 确保所有修复的有效性
```

### 7. 多目录工作流（新功能）

#### 添加目录
```bash
# 目录添加命令：
/add-dir ../project-name → 添加项目目录
/add-dir ./subdirectory → 添加子目录
/add-dir ../shared-configs → 添加共享配置目录

# 目录上下文：
多项目访问 → 同时在多个项目中工作
共享资源 → 跨项目访问配置和资源
统一视图 → 项目间一致的工作环境
```

#### 目录上下文
```bash
# 上下文管理：
项目感知 → 理解每个项目的特定上下文
路径解析 → 正确处理相对和绝对路径
依赖关系 → 识别和管理项目间依赖
一致性 → 跨项目保持一致的体验

# 工作流程：
文件引用 → 使用 @ 前缀引用任何项目中的文件
命令执行 → 在任何项目目录中执行命令
同步操作 → 跨项目同步更改和更新
```

#### Monorepo 模式
```bash
# Monorepo 支持：
包管理 → 跨包依赖管理和构建
类型共享 → 在包间共享类型定义
配置统一 → 跨项目配置和设置
测试集成 → 跨包测试和验证

# 开发效率：
同时开发 → 在多个包上并行工作
一致变更 → 确保跨包一致的更改
构建优化 → 优化的构建和打包过程
```

#### 全栈开发
```bash
# 全栈工作流：
前端 + 后端 → 同时监控前端和后端
实时同步 → 前后端更改的实时同步
共享类型 → 跨前后端的类型定义
统一调试 → 全栈问题的统一调试

# 监控两者：
Claude 同时监控前端和后端
可以在不停止另一个的情况下修复任一问题
跨组件验证 → 确保前后端集成正常工作
```

#### 跨项目迁移
```bash
# 迁移支持：
代码迁移 → 从旧项目迁移代码到新项目
知识转移 → 迁移项目特定知识和模式
配置适应 → 调整配置以适应新环境
测试迁移 → 迁移和适应测试用例

# Claude 功能：
读取来源 → Claude 可以从旧项目读取
写入目标 → Claude 可以写入到新项目
智能转换 → 在迁移过程中智能适应差异
```

#### 共享配置
```bash
# 配置共享：
全局访问 → 从任何项目访问共享配置
类型定义 → 跨项目共享TypeScript类型
工具配置 → 共享构建工具和linter配置
环境设置 → 共享环境和部署配置

# 一致性保证：
标准执行 → 确保跨项目的标准执行
版本同步 → 保持配置版本同步
更新传播 → 配置更改跨项目传播
```

### 8. 增强上下文管理（新功能）

#### 微压缩（新功能）
```bash
# 微压缩操作：
/microcompact → 智能压缩当前会话上下文

# 保留内容：
当前任务上下文 → 当前工作的相关上下文
最近交互 → 最近的用户交互和响应
CLAUDE.md → 项目上下文和配置信息

# 清除内容：
旧文件读取 → 之前读取的文件内容
已完成的操作 → 已完成的任务和操作
陈旧上下文 → 不再相关的旧上下文信息
```

#### 使用时机
```bash
# 何时使用每个选项：
/microcompact → 当会话变长但仍需当前上下文时
/compact "焦点" → 当切换到新任务但仍保留一些上下文时
/compact → 当需要完全新鲜开始时

# 自动优化：
智能触发 → 基于会话长度和复杂性自动建议
性能监控 → 监控上下文大小和性能影响
用户偏好 → 学习用户偏好和优化策略
```

#### 自动优化
```bash
# 优化策略：
性能优化 → 基于性能指标自动优化上下文
内存管理 → 智能内存使用和垃圾收集
响应性维护 → 确保快速响应的用户体验
质量保证 → 在优化过程中保持信息质量

# 自适应行为：
使用模式学习 → 从用户交互中学习模式
项目特定优化 → 针对项目特点的优化
实时调整 → 根据当前需求实时调整策略
```

#### 智能上下文分层
```bash
# 分层策略：
关键层 → 立即访问的重要信息
活动层 → 当前工作相关内容
背景层 → 支持信息和参考材料
归档层 → 历史信息和已完成的工作

# 访问模式：
即时访问 → 关键层信息立即可用
快速加载 → 活动层信息快速检索
按需加载 → 背景层按需加载
重建访问 → 归档层可根据需要重建
```

## 认知方法系统

### 认知模式如何工作
```bash
# 模式选择：
任务分析 → 理解任务需求和约束
模式匹配 → 选择最合适的认知模式
动态调整 → 根据进展反馈调整方法
学习进化 → 从经验中改进方法选择

# 执行原则：
意图驱动 → 理解用户意图而非字面指令
上下文感知 → 考虑项目和会话上下文
适应性 → 根据情况灵活调整方法
反思性 → 从结果中学习和改进
```

### 基于任务类型的认知模式
```bash
# 简单创建模式
适用场景：直接、明确的任务创建
特征：快速执行、最小分析、直接实现
示例：创建简单组件、编写基本函数

# 优化模式
适用场景：改进现有代码或性能
特征：分析当前状态、识别改进机会、验证结果
示例：性能优化、代码重构、效率改进

# 审查模式  
适用场景：代码质量和最佳实践评估
特征：全面分析、标准检查、改进建议
示例：代码审查、安全审计、质量评估

# 并行模式
适用场景：多个独立任务的并行处理
特征：并发执行、资源优化、进度监控
示例：批量文件处理、并行测试、多组件开发

# 编排模式
适用场景：复杂系统的协调和管理
特征：系统思维、依赖管理、整体优化
示例：架构设计、系统集成、复杂工作流

# 研究模式
适用场景：深入学习和知识获取
特征：深度分析、多源信息、综合理解
示例：技术调研、最佳实践研究、问题诊断
```

### 模式选择模式
```bash
# 选择标准：
任务复杂性 → 简单vs复杂任务的适当方法
用户专业知识 → 初学者vs专家的不同方法
项目阶段 → 规划vs开发vs维护的不同策略
时间约束 → 快速vs彻底的权衡

# 决策框架：
需求分析 → 理解任务的核心需求
约束评估 → 考虑时间、资源、技能约束
风险评估 → 评估不同方法的风险
经验应用 → 应用过去成功的方法
```

### 执行模式
```bash
# 通用执行原则：
增量进展 → 小步骤，持续验证
质量焦点 → 每个阶段的质量保证
用户协作 → 与用户互动和反馈
适应性 → 根据反馈和发现调整

# 特定模式执行：
模式特定操作 → 每种模式的独特方法
工具集成 → 适当工具的选择和使用
验证策略 → 针对模式的验证方法
学习整合 → 从执行中学习并改进
```

### 实际示例
```bash
# 创建多个相似项目
使用并行模式：并发创建，保持一致性
应用创建模式：每个项目的标准化实现
质量审查：确保一致的质量标准

# 构建完整功能
使用编排模式：协调多个组件和方面
结合创建模式：实现具体功能
优化模式：确保性能和质量

# 研究方法
使用研究模式：深入探索和理解
综合分析：整合多个信息源
实际应用：将研究转化为实践

# 优化代码
使用优化模式：识别和实施改进
性能分析：测量和验证改进
质量保证：确保优化不影响功能

# 系统设计
使用编排模式：整体系统架构
结合审查模式：验证设计决策
研究模式：探索最佳实践和技术选择
```

**关键理解**：认知方法系统提供智能、适应性、上下文感知的问题解决方法，根据任务需求、用户专业知识和项目约束选择最佳方法。