# 技术专家代理总览

本目录包含 5 个专业技术专家代理，为项目的技术问题提供专业咨询和解决方案。

## 专家代理列表

### 1. MCP 服务器集成专家 (`mcp-integration-expert.md`)
**专长领域**：
- Context7 MCP 服务器安装和配置
- Gemini MCP 服务器设置和优化
- MCP 服务器故障排除和调试
- API 密钥管理和安全配置

**适用场景**：
- MCP 服务器连接失败
- API 调用限制和错误
- 配置文件格式问题
- 性能优化需求

### 2. Shell 脚本编程专家 (`shell-scripting-expert.md`)
**专长领域**：
- 安装脚本开发和优化
- 自动化脚本设计
- Bash 编程最佳实践
- 错误处理和调试

**适用场景**：
- 安装脚本开发和维护
- 自动化部署和配置
- 脚本性能优化
- 跨平台兼容性问题

### 3. Claude Code 配置专家 (`claude-config-expert.md`)
**专长领域**：
- settings.json 配置管理
- Hook 系统开发和配置
- 命令系统管理
- 性能调优和故障排除

**适用场景**：
- 配置文件错误和冲突
- Hook 脚本执行失败
- 命令执行问题
- 开发环境配置

### 4. 中文本地化专家 (`chinese-localization-expert.md`)
**专长领域**：
- 技术文档翻译和本地化
- 界面文本汉化
- 国际化架构设计
- 用户体验优化

**适用场景**：
- 文档翻译需求
- 界面本地化问题
- 中文字符编码问题
- 翻译质量改进

### 5. 模板管理专家 (`template-management-expert.md`)
**专长领域**：
- 项目模板设计和创建
- 文档模板标准化
- 代码模板管理
- 模板质量保证

**适用场景**：
- 项目模板开发
- 文档标准化需求
- 代码片段管理
- 模板维护和更新

## 使用方法

### 调用专家代理
在 Claude Code 中，可以使用以下方式调用专家代理：

```bash
# 使用 Task 工具调用特定专家
Task "subagent_type=general-purpose&prompt=请分析我的 MCP 配置问题"
```

### 选择合适的专家
根据问题的类型选择相应的专家：
- **配置和连接问题** → MCP 集成专家
- **脚本和自动化问题** → Shell 脚本专家
- **Claude Code 配置问题** → 配置专家
- **翻译和本地化问题** → 本地化专家
- **模板和标准化问题** → 模板管理专家

## 专家代理特点

### 专业深度
每个专家都在其领域具有深厚的专业知识，能够提供准确和深入的解决方案。

### 实用导向
所有专家都专注于解决实际的技术问题，提供可操作的解决方案。

### 中文支持
专家代理都支持中文交流，能够用中文解释复杂的技术概念。

### 经验丰富
基于项目的实际需求和经验，专家能够提供实用的最佳实践建议。

## 更新和维护

专家代理会根据项目发展和技术更新进行持续优化，确保提供最新的技术支持和解决方案。