# MCP 助手规则 - [项目名称]

## 项目上下文
[简要描述你的项目功能和主要目的。保持简洁 - 最多2-3句话。]

### 核心愿景与架构
- **产品目标**：[产品的主要目标]
- **目标平台**：[主要平台 - web、移动端、桌面等]
- **架构**：[高层架构概述]
- **关键技术**：[使用的主要技术/框架]

### 关键技术原则
[列出指导项目的4-6个核心技术原则]
- **示例**：基于会话的架构，边界清晰
- **示例**：API 优先设计，从第一天开始版本化
- **示例**：默认安全 - 在边界处验证所有输入
- **示例**：可观测系统，结构化日志记录

**注意：**完整的项目结构和技术栈在附加的 `project-structure.md` 文件中提供。

## 关键项目标准

### 核心原则
[列出你的基本开发原则]
- 遵循 KISS、YAGNI 和 DRY - 优先选择经过验证的解决方案而不是自定义实现
- 永远不要模拟、使用占位符或省略代码 - 始终完全实现
- 对想法的好坏要坦率诚实
- [添加项目特定原则]

### 代码组织
[定义你的代码组织标准]
- 保持文件在 [X] 行以内 - 通过提取工具、常量、类型来拆分
- 每个文件单一职责，目的明确
- 优先组合而非继承
- [添加特定语言/框架的组织规则]

### [语言] 标准
[替换为你的主要语言及其标准]
- 类型安全要求
- 命名约定（类、函数、常量）
- 文档要求（docstring 风格、必需元素）
- 错误处理模式

### 错误处理与日志记录
- 使用具体异常，提供有用消息
- 仅结构化日志记录 - 定义你的日志记录方法
- [指定日志记录类别或模式]
- 每个请求都需要关联 ID 用于追踪

### API 设计
[如适用 - 定义 API 标准]
- RESTful，URL 模式一致
- 从第一天开始版本化（/v1/、/v2/）
- 一致的响应格式
- 正确的 HTTP 状态码

### 安全与状态
- 永远不要信任外部输入 - 在边界处验证
- [定义会话/状态管理方法]
- [指定数据保留策略]
- 仅在环境变量中保存秘钥

## 项目特定指南
[添加 AI 助手应该知道的任何项目特定指南]

### 领域特定规则
[添加特定于你问题领域的规则]

### 集成点
[列出关键集成点或外部服务]

### 性能考虑
[添加任何性能关键方面]

## 重要约束
- 你不能创建、修改或执行代码
- 你在只读支持能力中运作
- 你的建议是给主要 AI（Claude Code）实现的
- 专注于分析、理解和咨询支持

## 快速参考
[添加经常需要的信息]
- 关键命令：[列出常用命令]
- 重要路径：[列出关键文件路径]
- 文档链接：[添加详细文档链接]