# [组件名称] - 组件上下文（第2层）

> **注意**：这是组件特定上下文。参见根目录 **CLAUDE.md** 了解主项目上下文和编码标准。

## 用途
[简要描述此组件在系统中的作用。它解决什么问题，如何融入整体架构？]

## 当前状态：[状态描述] ✅/🚧/📋
[当前实现状态，什么在工作，什么在进行中，以及实现的关键里程碑]

## 组件特定开发指南
- **[技术/框架]**：[此组件的特定技术要求]
- **[架构模式]**：[组件特定架构方法]
- **[代码组织]**：[此组件内代码应如何结构化]
- **[集成模式]**：[此组件如何与其他组件集成]
- **[质量标准]**：[组件特定质量要求]

## 关键组件结构

### 核心模块 (`[路径]/`)
- **[模块1]/** - [用途和关键功能]
  - **[文件1].[扩展名]** - [特定文件用途和关键特性]
  - **[文件2].[扩展名]** - [特定文件用途和关键特性]
- **[模块2]/** - [用途和关键功能]  
- **[模块3]/** - [用途和关键功能]

### [辅助结构] (`[路径]/`)
- **[组件].[扩展名]** - [组件用途和架构模式]
- **[工具].[扩展名]** - [工具函数和辅助器]
- **[配置].[扩展名]** - [配置和设置管理]

### [集成层] (`[路径]/`)
- **[集成1].[扩展名]** - [外部服务集成模式]
- **[集成2].[扩展名]** - [组件间通信]

## 实现亮点

### [关键特性1]
- **[技术实现]**：[此特性如何实现]
- **[架构决策]**：[为什么选择这种方法]
- **[性能考虑]**：[优化细节]
- **[集成点]**：[如何连接到其他组件]

### [关键特性2]  
- **[实现模式]**：[技术实现方法]
- **[质量措施]**：[测试、监控、错误处理]
- **[可扩展性考虑]**：[如何处理增长/负载]

### [关键特性3]
- **[技术细节]**：[实现细节]
- **[依赖关系]**：[外部依赖和集成点]
- **[配置]**：[如何配置和自定义]

## 关键实现细节

### [技术模式1]
**[模式描述]**：[此模式解决什么问题]

```[语言]
// 显示模式的实现示例
[演示关键实现的代码示例]
```

### [技术模式2]  
**[架构决策]**：[为什么选择这种方法]

```[语言]
// 显示架构实现的代码示例
[演示架构的代码示例]
```

### [集成模式]
**[集成描述]**：[此组件如何与其他组件集成]

```[语言]
// 集成实现示例  
[显示集成模式的代码示例]
```

## 开发注意事项

### [当前挑战]
- **[挑战1]**：[描述和当前方法]
- **[挑战2]**：[描述和缓解策略]

### [未来考虑]
- **[增强1]**：[计划改进和理由]
- **[增强2]**：[未来架构演进]

### [性能指标]
- **[关键指标1]**：[当前性能和目标]
- **[关键指标2]**：[监控和优化方法]

---

*此组件文档为 [组件名称] 内的 AI 辅助开发提供上下文。有关系统级模式和标准，请参考主 CLAUDE.md 文件。*