# 任务交接文档

*此文档帮助在 Claude Code 会话之间维护上下文连续性和任务状态。*

## 当前会话状态

### 主要目标
[描述当前会话的主要目标或项目重点]

### 已完成任务
- [x] [已完成的任务1] - [简要说明和结果]
- [x] [已完成的任务2] - [关键成果和影响]
- [x] [已完成的任务3] - [实现细节和文档位置]

### 正在进行的任务
- [ ] [进行中的任务1] - [当前状态和下一步]
- [ ] [进行中的任务2] - [遇到的挑战和解决方向]
- [ ] [进行中的任务3] - [依赖关系和时间线]

### 待办任务
- [ ] [待办任务1] - [优先级和预期工作量]
- [ ] [待办任务2] - [前置条件和资源需求]
- [ ] [待办任务3] - [相关文档和参考资料]

## 技术上下文

### 当前技术状态
**架构决策**: [最近的重要架构决策]
**性能状态**: [当前性能指标和优化需求]
**集成状态**: [外部服务集成状态]
**测试覆盖**: [测试状态和质量指标]

### 关键发现和洞察
- **[技术洞察1]**: [发现的问题和建议解决方案]
- **[架构洞察2]**: [系统设计改进机会]
- **[性能洞察3]**: [优化建议和预期收益]

### 需要关注的技术债务
1. **[技术债务1]** - [影响和紧急程度] - [建议解决时间线]
2. **[技术债务2]** - [风险评估] - [缓解措施]
3. **[技术债务3]** - [重构建议] - [资源需求]

## 文档系统状态

### 文档完整性
- **第1层文档**: [基础文档状态 - 完整/需更新/缺失]
- **第2层文档**: [组件文档覆盖率和质量]
- **第3层文档**: [功能文档的同步状态]

### 文档更新需求
- [ ] [需要更新的文档1] - [更新原因和优先级]
- [ ] [需要创建的文档2] - [缺失的上下文和影响]
- [ ] [需要重构的文档3] - [当前问题和改进方向]

## 决策记录

### 最近的重要决策
**[决策日期]**: [决策标题]
- **背景**: [导致决策的情况]
- **选择**: [做出的决策和理由]
- **影响**: [对项目的影响和后续行动]
- **状态**: [实施状态和验证结果]

### 待决策问题
1. **[待决策问题1]** - [问题描述和选项分析]
2. **[待决策问题2]** - [利益相关者和决策时间线]
3. **[待决策问题3]** - [风险评估和建议方向]

## 下次会话建议

### 优先事项
1. **[高优先级任务]** - [为什么重要和预期结果]
2. **[中优先级任务]** - [依赖关系和资源需求]
3. **[低优先级任务]** - [时间线和质量要求]

### 上下文提醒
- **关键文件**: [下次会话应该首先查看的文件]
- **重要约束**: [需要记住的技术或业务约束]
- **相关联系人**: [可能需要咨询的团队成员或专家]

### 预期挑战
- **[技术挑战]** - [预期困难和准备建议]
- **[资源挑战]** - [时间或人力资源限制]
- **[集成挑战]** - [与其他系统或团队的协调需求]

## 资源和参考

### 关键文档链接
- [重要文档1] - [为什么重要和使用场景]
- [参考资料2] - [相关技术文档或标准]
- [决策记录3] - [历史决策和当前相关性]

### 外部资源
- [API文档] - [第三方服务文档]
- [技术规范] - [行业标准或最佳实践]
- [社区资源] - [有用的开源项目或讨论]

### 团队联系信息
- **[角色1]**: [联系方式] - [负责领域和可用时间]
- **[角色2]**: [联系方式] - [专业领域和协作方式]

---

*定期更新此文档以确保会话间的连续性和效率。每次主要任务完成或会话结束时都应更新相关部分。*