/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;
import com.watabou.utils.Bundle;

public class AccuracyBuff
extends Buff {
    private int count = 0;
    private int maxCount;
    private boolean lastAttacked;
    private static final String COUNT = "count";
    private static final String MAXCOUNT = "maxCount";
    private static final String LASTATTACKED = "lastAttacked";

    public AccuracyBuff() {
        this.maxCount = 1 + Dungeon.hero.belongings.weapon.buffedLvl();
        this.lastAttacked = false;
    }

    @Override
    public int icon() {
        return 27;
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0, (this.maxCount - this.count) / this.maxCount);
    }

    public int getCount() {
        return this.count;
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    public void attack(Char enemy) {
        this.count = this.count < this.maxCount ? ++this.count : this.maxCount;
        this.lastAttacked = true;
        BuffIndicator.refreshHero();
    }

    @Override
    public void detach() {
        super.detach();
    }

    @Override
    public boolean act() {
        if (!this.lastAttacked) {
            this.count = (int)((float)this.count - 1.0f);
        } else {
            this.lastAttacked = false;
        }
        this.spend(1.0f);
        if (this.count <= 0) {
            this.detach();
        }
        return true;
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.count, 5 * this.count, this.maxCount);
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(COUNT, this.count);
        bundle.put(MAXCOUNT, this.maxCount);
        bundle.put(LASTATTACKED, this.lastAttacked);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.count = bundle.getInt(COUNT);
        this.maxCount = bundle.getInt(MAXCOUNT);
        this.lastAttacked = bundle.getBoolean(LASTATTACKED);
    }
}

