/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;
import com.watabou.noosa.Image;
import com.watabou.utils.Bundle;
import java.text.DecimalFormat;

public class DamageEnhance
extends Buff {
    private float dmgBonus = 0.0f;
    private float duration = 0.0f;
    private float initialDuration = 0.0f;
    private static final String DMGBONUS = "dmgBonus";
    private static final String DURATION = "duration";
    private static final String INITIALDURATION = "initialDuration";

    @Override
    public int icon() {
        return 42;
    }

    @Override
    public void tintIcon(Image icon) {
        switch (Dungeon.hero.pointsInTalent(Talent.DONG_POLISHING)) {
            default: {
                icon.hardlight(0.0f, 0.0f, 0.0f);
                break;
            }
            case 2: {
                icon.hardlight(1.0f, 1.0f, 0.0f);
                break;
            }
            case 3: {
                icon.hardlight(1.0f, 0.0f, 0.0f);
            }
        }
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0.0f, (this.initialDuration - this.duration) / this.initialDuration);
    }

    public float getDmg() {
        return this.dmgBonus;
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    public void set() {
        this.dmgBonus = 1.0f + 0.2f * (float)Dungeon.hero.pointsInTalent(Talent.DONG_POLISHING);
        switch (Dungeon.hero.pointsInTalent(Talent.DONG_POLISHING)) {
            default: {
                this.duration = 10.0f;
                break;
            }
            case 2: {
                this.duration = 5.0f;
                break;
            }
            case 3: {
                this.duration = 3.0f;
            }
        }
        this.initialDuration = this.duration;
        BuffIndicator.refreshHero();
    }

    public void addTime(float time) {
        this.duration += time;
    }

    @Override
    public void detach() {
        super.detach();
    }

    @Override
    public boolean act() {
        this.duration -= 1.0f;
        this.spend(1.0f);
        if (this.duration <= 0.0f) {
            this.detach();
        }
        return true;
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", new DecimalFormat("#").format(100.0f * this.dmgBonus), this.dispTurns(this.duration));
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(DMGBONUS, this.dmgBonus);
        bundle.put(DURATION, this.duration);
        bundle.put(INITIALDURATION, this.initialDuration);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.dmgBonus = bundle.getFloat(DMGBONUS);
        this.duration = bundle.getFloat(DURATION);
        this.initialDuration = bundle.getFloat(INITIALDURATION);
    }
}

