/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Sheathing;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroAction;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.NPC;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Lightning;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.SparkParticle;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.CellSelector;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.tiles.DungeonTilemap;
import com.shatteredpixel.shatteredpixeldungeon.ui.ActionIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.HeroIcon;
import com.shatteredpixel.shatteredpixeldungeon.utils.BArray;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.Image;
import com.watabou.noosa.Visual;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.PathFinder;

public class Dong
extends Buff
implements ActionIndicator.Action {
    private CellSelector.Listener attack;

    public Dong() {
        this.actPriority = -31;
        this.announced = true;
        this.attack = new CellSelector.Listener(){

            @Override
            public void onSelect(Integer cell) {
                if (cell == null) {
                    return;
                }
                Char enemy = Actor.findChar(cell);
                if (enemy == null || Dungeon.hero.isCharmedBy(enemy) || enemy instanceof NPC || !Dungeon.level.heroFOV[cell] || enemy instanceof Hero) {
                    if (Dungeon.hero.hasTalent(Talent.DONG_SHEATHING) && enemy instanceof Hero) {
                        Dungeon.hero.buff(Sheathing.class).detach();
                        Dungeon.hero.spendAndNext(1.0f);
                    } else {
                        GLog.w(Messages.get(Dong.class, "no_target", new Object[0]), new Object[0]);
                    }
                } else {
                    if (Dungeon.hero.canAttack(enemy)) {
                        Dungeon.hero.curAction = new HeroAction.Attack(enemy);
                        Dungeon.hero.next();
                        return;
                    }
                    PathFinder.buildDistanceMap(Dungeon.hero.pos, BArray.not(Dungeon.level.solid, null), Dong.this.blinkDistance());
                    int dest = -1;
                    for (int i : PathFinder.NEIGHBOURS8) {
                        if (Actor.findChar(cell + i) != null || !Dungeon.level.passable[cell + i]) continue;
                        if (dest == -1 || PathFinder.distance[dest] > PathFinder.distance[cell + i]) {
                            dest = cell + i;
                            continue;
                        }
                        if (PathFinder.distance[dest] != PathFinder.distance[cell + i] || !(Dungeon.level.trueDistance(Dungeon.hero.pos, dest) > Dungeon.level.trueDistance(Dungeon.hero.pos, cell + i))) continue;
                        dest = cell + i;
                    }
                    if (dest == -1 || PathFinder.distance[dest] == Integer.MAX_VALUE || Dungeon.hero.rooted) {
                        GLog.w(Messages.get(Dong.class, "out_of_reach", new Object[0]), new Object[0]);
                        return;
                    }
                    Dungeon.hero.pos = dest;
                    Dungeon.level.occupyCell(Dungeon.hero);
                    Dungeon.observe();
                    GameScene.updateFog();
                    Dungeon.hero.checkVisibleMobs();
                    Dungeon.hero.sprite.parent.add(new Lightning(Dungeon.hero.sprite.center(), DungeonTilemap.raisedTileCenterToWorld(Dungeon.hero.pos), null));
                    CellEmitter.center(Dungeon.hero.pos).burst(SparkParticle.FACTORY, 3);
                    Dungeon.hero.sprite.place(Dungeon.hero.pos);
                    Dungeon.hero.sprite.turnTo(Dungeon.hero.pos, cell);
                    CellEmitter.get(Dungeon.hero.pos).burst(Speck.factory(7), 6);
                    Sample.INSTANCE.play("sounds/puff.mp3");
                    Dungeon.hero.curAction = new HeroAction.Attack(enemy);
                    Dungeon.hero.next();
                }
            }

            @Override
            public String prompt() {
                return Messages.get(Dong.class, "prompt", Dong.this.blinkDistance());
            }
        };
    }

    public int blinkDistance() {
        return 500;
    }

    @Override
    public boolean act() {
        if (this.blinkDistance() > 0 && this.target == Dungeon.hero) {
            ActionIndicator.setAction(this);
            this.spend(1.0f);
        } else {
            this.detach();
        }
        return true;
    }

    @Override
    public void detach() {
        super.detach();
        ActionIndicator.clearAction(this);
    }

    @Override
    public int icon() {
        return 138;
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String desc() {
        String desc = Messages.get(this, "desc", new Object[0]);
        return desc;
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        ActionIndicator.setAction(this);
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
    }

    @Override
    public String actionName() {
        if (Dungeon.hero.buff(Sheathing.class) != null) {
            return Messages.get(this, "action_name", new Object[0]);
        }
        return Messages.get(this, "action_name_sheath", new Object[0]);
    }

    @Override
    public int actionIcon() {
        return 106;
    }

    @Override
    public int indicatorColor() {
        return 0xFFFFFF;
    }

    @Override
    public Visual primaryVisual() {
        HeroIcon actionIco = new HeroIcon(this);
        this.tintIcon(actionIco);
        return actionIco;
    }

    @Override
    public void tintIcon(Image icon) {
        icon.hardlight(1.0f, 0.0f, 0.0f);
    }

    @Override
    public void doAction() {
        if (Dungeon.hero.buff(Sheathing.class) != null) {
            GameScene.selectCell(this.attack);
        } else {
            Buff.affect(Dungeon.hero, Sheathing.class);
            Dungeon.hero.spendAndNext(1.0f);
        }
    }
}

