/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.watabou.noosa.Image;
import com.watabou.utils.Bundle;

public class EnhancedRingsCombo
extends FlavourBuff {
    int combo;
    private static final String COMBO = "combo";

    public EnhancedRingsCombo() {
        this.type = Buff.buffType.POSITIVE;
        this.combo = 0;
    }

    public void hit() {
        this.combo = this.combo < Dungeon.hero.pointsInTalent(Talent.RING_KNUCKLE) ? ++this.combo : Dungeon.hero.pointsInTalent(Talent.RING_KNUCKLE);
        if (this.target instanceof Hero) {
            ((Hero)this.target).updateHT(false);
        }
    }

    public int getCombo() {
        return this.combo;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(COMBO, this.combo);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.combo = bundle.getInt(COMBO);
    }

    @Override
    public boolean attachTo(Char target) {
        return super.attachTo(target);
    }

    @Override
    public void detach() {
        super.detach();
        if (this.target instanceof Hero) {
            ((Hero)this.target).updateHT(false);
        }
        Item.updateQuickslot();
    }

    @Override
    public int icon() {
        return 50;
    }

    @Override
    public void tintIcon(Image icon) {
        icon.hardlight(0.0f, 1.0f, 0.0f);
    }

    @Override
    public float iconFadePercent() {
        float max = Dungeon.hero.pointsInTalent(Talent.RING_KNUCKLE) >= 2 ? 2.0f : 1.0f;
        return Math.max(0.0f, (max - this.visualcooldown()) / max);
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", (int)this.visualcooldown(), this.combo);
    }
}

