/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.watabou.noosa.Image;
import com.watabou.utils.Bundle;

public class IntervalWeaponUpgrade
extends Buff {
    private int boost;
    private float interval;
    private static final String BOOST = "boost";
    private static final String INTERVAL = "interval";

    public IntervalWeaponUpgrade() {
        this.type = Buff.buffType.POSITIVE;
    }

    public void levelUp() {
        if (this.boost < 3) {
            ++this.boost;
        }
        switch (this.boost) {
            default: {
                this.interval = 50.0f;
                break;
            }
            case 2: {
                this.interval = 30.0f;
                break;
            }
            case 3: {
                this.interval = 10.0f;
            }
        }
        this.spend(this.interval - this.cooldown());
    }

    public int boost() {
        return this.boost;
    }

    @Override
    public boolean act() {
        --this.boost;
        switch (this.boost) {
            default: {
                this.interval = 50.0f;
                break;
            }
            case 2: {
                this.interval = 30.0f;
                break;
            }
            case 3: {
                this.interval = 10.0f;
            }
        }
        if (this.boost > 0) {
            this.spend(this.interval);
        } else {
            this.detach();
        }
        Item.updateQuickslot();
        return true;
    }

    @Override
    public int icon() {
        return 45;
    }

    @Override
    public void tintIcon(Image icon) {
        switch (this.boost) {
            default: {
                icon.hardlight(0xFFFFFF);
                break;
            }
            case 2: {
                icon.hardlight(0xFFFF00);
                break;
            }
            case 3: {
                icon.hardlight(0xFF0000);
            }
        }
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0.0f, (this.interval - this.visualcooldown()) / this.interval);
    }

    @Override
    public String iconTextDisplay() {
        return Integer.toString((int)this.visualcooldown());
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.boost, this.dispTurns(this.visualcooldown()));
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(BOOST, this.boost);
        bundle.put(INTERVAL, this.interval);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.boost = bundle.getInt(BOOST);
        this.interval = bundle.getFloat(INTERVAL);
    }
}

