/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.watabou.noosa.Image;
import com.watabou.utils.Bundle;
import java.text.DecimalFormat;

public class LanceBuff
extends Buff {
    float damageFactor;
    float maxDamage;
    boolean secondWep;
    Item item;
    private static final String DAMAGE = "damage";
    private static final String MAXDAMAGE = "maxdamage";

    public LanceBuff() {
        this.type = Buff.buffType.NEUTRAL;
        this.announced = false;
        this.damageFactor = 0.0f;
        this.maxDamage = 2.0f;
        this.secondWep = false;
        this.item = null;
    }

    public void setDamageFactor(float amount, boolean isSecond) {
        this.secondWep = isSecond;
        this.damageFactor = this.damageFactor < this.maxDamage && this.damageFactor + 0.05f * amount < this.maxDamage ? (this.damageFactor += 0.05f * amount) : this.maxDamage + 0.05f;
    }

    public float getDamageFactor() {
        return this.damageFactor;
    }

    public float duration() {
        return this.visualcooldown();
    }

    @Override
    public int icon() {
        return 45;
    }

    @Override
    public void tintIcon(Image icon) {
        icon.hardlight(0.2f, 1.0f, 0.2f);
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0.0f, this.maxDamage - this.damageFactor / this.maxDamage - 1.0f);
    }

    @Override
    public boolean act() {
        this.damageFactor -= 0.05f;
        this.spend(1.0f);
        if (this.damageFactor <= 0.0f) {
            this.detach();
        }
        if (this.item == null) {
            this.item = this.secondWep ? Dungeon.hero.belongings.secondWep : Dungeon.hero.belongings.weapon;
        }
        if (this.item != Dungeon.hero.belongings.weapon && this.item != Dungeon.hero.belongings.secondWep) {
            this.detach();
        }
        return true;
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", new DecimalFormat("#.##").format(1.0f + this.getDamageFactor()));
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(DAMAGE, this.damageFactor);
        bundle.put(MAXDAMAGE, this.maxDamage);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.damageFactor = bundle.getFloat(DAMAGE);
        this.maxDamage = bundle.getFloat(MAXDAMAGE);
    }
}

