/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.watabou.noosa.Image;
import com.watabou.utils.Bundle;
import java.text.DecimalFormat;

public class LargeSwordBuff
extends Buff {
    float damageFactor;
    float accuracyFactor;
    float defenseFactor;
    float maxDamage;
    float maxAccuracy;
    int turn;
    boolean secondWep;
    public int pos;
    Item item;
    private static final String DAMAGE_FACTOR = "damageFactor";
    private static final String ACCURACY_FACTOR = "accuracyFactor";
    private static final String MAX_DAMAGE = "maxDamage";
    private static final String MAX_ACCURACY = "maxAccuracy";
    private static final String DEFENSE_FACTOR = "defenseFactor";
    private static final String TURN = "turn";
    private static final String POS = "pos";

    public LargeSwordBuff() {
        this.type = Buff.buffType.NEUTRAL;
        this.announced = false;
        this.damageFactor = 1.0f;
        this.accuracyFactor = 1.0f;
        this.defenseFactor = 0.9f;
        this.turn = 0;
        this.secondWep = false;
        this.pos = -1;
        this.item = null;
    }

    public void setDamageFactor(float lvl, boolean isSecond) {
        this.setDamageFactor(lvl, 1, isSecond);
    }

    public void setDamageFactor(float lvl, int amount, boolean isSecond) {
        this.secondWep = isSecond;
        this.turn += amount;
        this.maxDamage = 1.8f + 0.2f * (lvl + 1.0f);
        this.maxAccuracy = 1.4f + 0.1f * (lvl + 1.0f);
        this.damageFactor += 0.2f;
        this.accuracyFactor += 0.1f;
        this.defenseFactor = (float)Math.pow(0.9f, lvl + 1.0f);
        if (this.damageFactor > this.maxDamage) {
            this.damageFactor = this.maxDamage;
        }
        if (this.accuracyFactor > this.maxAccuracy) {
            this.accuracyFactor = this.maxAccuracy;
        }
    }

    public float getDefenseFactor() {
        return this.defenseFactor;
    }

    public float getDamageFactor() {
        return this.damageFactor;
    }

    public float getAccuracyFactor() {
        return this.accuracyFactor;
    }

    public float duration() {
        return this.visualcooldown();
    }

    @Override
    public int icon() {
        return 45;
    }

    @Override
    public void tintIcon(Image icon) {
        if (this.damageFactor <= 1.2f) {
            icon.hardlight(0.5f, 1.0f, 0.0f);
        } else if (this.damageFactor <= 1.4f) {
            icon.hardlight(1.0f, 1.0f, 0.0f);
        } else if (this.damageFactor <= 1.6f) {
            icon.hardlight(1.0f, 0.67f, 0.0f);
        } else if (this.damageFactor <= 1.8f) {
            icon.hardlight(1.0f, 0.33f, 0.0f);
        } else {
            icon.hardlight(1.0f, 0.0f, 0.0f);
        }
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0.0f, 1.0f - (this.damageFactor - 1.0f) / (this.maxDamage - 1.0f));
    }

    @Override
    public boolean act() {
        if (this.pos == -1) {
            this.pos = this.target.pos;
        }
        if (this.item == null) {
            this.item = this.secondWep ? Dungeon.hero.belongings.secondWep : Dungeon.hero.belongings.weapon;
        }
        if (this.item != Dungeon.hero.belongings.weapon && this.item != Dungeon.hero.belongings.secondWep) {
            this.detach();
        }
        if (this.pos != this.target.pos) {
            this.detach();
        }
        this.spend(1.0f);
        return true;
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.turn, new DecimalFormat("#").format((this.getDamageFactor() - 1.0f) * 100.0f), new DecimalFormat("#").format((this.maxDamage - 1.0f) * 100.0f), new DecimalFormat("#").format((this.getAccuracyFactor() - 1.0f) * 100.0f), new DecimalFormat("#").format((this.maxAccuracy - 1.0f) * 100.0f), new DecimalFormat("#.##").format((1.0f - this.defenseFactor) * 100.0f));
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(DAMAGE_FACTOR, this.damageFactor);
        bundle.put(ACCURACY_FACTOR, this.accuracyFactor);
        bundle.put(MAX_DAMAGE, this.maxDamage);
        bundle.put(MAX_ACCURACY, this.maxAccuracy);
        bundle.put(DEFENSE_FACTOR, this.defenseFactor);
        bundle.put(TURN, this.turn);
        bundle.put(POS, this.pos);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.damageFactor = bundle.getFloat(DAMAGE_FACTOR);
        this.accuracyFactor = bundle.getFloat(ACCURACY_FACTOR);
        this.maxDamage = bundle.getFloat(MAX_DAMAGE);
        this.maxAccuracy = bundle.getFloat(MAX_ACCURACY);
        this.defenseFactor = bundle.getFloat(DEFENSE_FACTOR);
        this.turn = bundle.getInt(TURN);
        this.pos = bundle.getInt(POS);
    }
}

