/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.MagicalParticle;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;
import com.shatteredpixel.shatteredpixeldungeon.utils.BArray;
import com.watabou.noosa.Image;
import com.watabou.noosa.particles.Emitter;
import com.watabou.utils.Bundle;
import com.watabou.utils.PathFinder;
import java.util.ArrayList;

public class MagicalCircle
extends Buff {
    private ArrayList<Integer> areaPositions = new ArrayList();
    private ArrayList<Emitter> areaEmitters = new ArrayList();
    private ArrayList<Char> targets = new ArrayList();
    private ArrayList<Char> enemy = new ArrayList();
    private static final float DURATION = 20.0f;
    int left = 0;
    private static final String AREA_POSITIONS = "area_positions";
    private static final String LEFT = "left";

    public MagicalCircle() {
        this.type = Buff.buffType.POSITIVE;
    }

    @Override
    public int icon() {
        return 50;
    }

    @Override
    public void tintIcon(Image icon) {
        icon.hardlight(41215);
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0.0f, (20.0f - (float)this.left) / 20.0f);
    }

    @Override
    public String iconTextDisplay() {
        return Integer.toString(this.left);
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.left);
    }

    public void setup(int pos, int duration) {
        int dist = 0;
        if (Dungeon.hero.pointsInTalent(Talent.MAGICAL_CIRCLE) == 3) {
            ++dist;
        }
        PathFinder.buildDistanceMap(pos, BArray.or(Dungeon.level.passable, Dungeon.level.avoid, null), dist);
        for (int i = 0; i < PathFinder.distance.length; ++i) {
            if (PathFinder.distance[i] >= Integer.MAX_VALUE || this.areaPositions.contains(i)) continue;
            this.areaPositions.add(i);
        }
        if (this.target != null) {
            this.fx(false);
            this.fx(true);
        }
        this.left = duration;
    }

    public void extend(int duration) {
        this.left += duration;
    }

    @Override
    public boolean act() {
        if (!this.areaPositions.contains(this.target.pos)) {
            this.detach();
        }
        --this.left;
        BuffIndicator.refreshHero();
        if (this.left <= 0) {
            this.detach();
        }
        this.spend(1.0f);
        return true;
    }

    @Override
    public void fx(boolean on) {
        if (on) {
            for (int i : this.areaPositions) {
                Emitter e = CellEmitter.get(i);
                e.pour(MagicalParticle.FACTORY, 0.05f);
                this.areaEmitters.add(e);
            }
        } else {
            for (Emitter e : this.areaEmitters) {
                e.on = false;
            }
            this.areaEmitters.clear();
        }
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        int[] values = new int[this.areaPositions.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.areaPositions.get(i);
        }
        bundle.put(AREA_POSITIONS, values);
        bundle.put(LEFT, this.left);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        int[] values;
        super.restoreFromBundle(bundle);
        for (int value : values = bundle.getIntArray(AREA_POSITIONS)) {
            this.areaPositions.add(value);
        }
        this.left = bundle.getInt(LEFT);
    }
}

