/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blob;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Electricity;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Fire;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Freezing;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Adrenaline;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Amok;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bless;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Blindness;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Burning;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Charm;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Corrosion;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Frost;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Light;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MagicalEmpower;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Paralysis;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Recharging;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Roots;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.MagicMissile;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.effects.SpellSprite;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ShadowParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.Artifact;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfMagicMapping;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.Wand;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfBlastWave;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfCorrosion;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfCorruption;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfDisintegration;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfFireblast;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfFrost;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfLightning;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfLivingEarth;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfMagicMissile;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfPrismaticLight;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfRegrowth;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfTransfusion;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfWarding;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MagesStaff;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.Terrain;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.ConeAOE;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.CellSelector;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.ActionIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.AttackIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndMagicalCombo;
import com.watabou.noosa.Image;
import com.watabou.noosa.Visual;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Callback;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import com.watabou.utils.Reflection;
import java.util.HashMap;
import java.util.Iterator;

public class MagicalCombo
extends Buff
implements ActionIndicator.Action {
    private int count = 0;
    private float comboTime = 0.0f;
    private float initialComboTime = 5.0f;
    private static final String COUNT = "count";
    private static final String TIME = "combotime";
    private static final String INITIAL_TIME = "initialComboTime";
    private static final HashMap<Class<? extends Wand>, Integer> effectTypes = new HashMap();
    private static final HashMap<Class<? extends Wand>, Float> damageFactors;
    private static ComboMove moveBeingUsed;
    private CellSelector.Listener listener = new CellSelector.Listener(){

        @Override
        public void onSelect(Integer cell) {
            if (cell == null) {
                return;
            }
            final Char enemy = Actor.findChar(cell);
            if (enemy == null || enemy == MagicalCombo.this.target || !Dungeon.level.heroFOV[cell] || MagicalCombo.this.target.isCharmedBy(enemy)) {
                GLog.w(Messages.get(MagicalCombo.class, "bad_target", new Object[0]), new Object[0]);
            } else {
                Dungeon.hero.busy();
                MagicalCombo.this.target.sprite.attack(cell, new Callback(){

                    @Override
                    public void call() {
                        MagicalCombo.this.doAttack(enemy);
                    }
                });
            }
        }

        @Override
        public String prompt() {
            return Messages.get(MagicalCombo.class, "prompt", new Object[0]);
        }
    };
    private CellSelector.Listener magicEmmit = new CellSelector.Listener(){

        @Override
        public void onSelect(Integer cell) {
            if (cell == null) {
                return;
            }
            if (cell == Dungeon.hero.pos) {
                GLog.w(Messages.get(MagicalCombo.class, "bad_target", new Object[0]), new Object[0]);
            } else {
                Ballistica aim = new Ballistica(Dungeon.hero.pos, cell, 0);
                int maxDist = MagicalCombo.this.count;
                int dist = Math.min(aim.dist, maxDist);
                ConeAOE cone = new ConeAOE(aim, dist, 30.0f, 5);
                for (Ballistica ray : cone.outerRays) {
                    ((MagicMissile)Dungeon.hero.sprite.parent.recycle(MagicMissile.class)).reset(100, (Visual)Dungeon.hero.sprite, (int)ray.path.get(ray.dist), null);
                }
                int affectedChar = 0;
                for (int cells : cone.cells) {
                    Char ch = Actor.findChar(cells);
                    if (ch == null || ch.alignment == Dungeon.hero.alignment) continue;
                    int damage = Random.NormalIntRange(10, 20);
                    ch.damage(damage -= ch.drRoll(), Dungeon.hero);
                    ++affectedChar;
                }
                if (affectedChar > 0) {
                    for (Buff b : Dungeon.hero.buffs()) {
                        if (!(b instanceof Artifact.ArtifactBuff) || ((Artifact.ArtifactBuff)b).isCursed()) continue;
                        ((Artifact.ArtifactBuff)b).charge(Dungeon.hero, affectedChar);
                    }
                    SpellSprite.show(Dungeon.hero, 2);
                }
                Sample.INSTANCE.play("sounds/chargeup.mp3", 1.0f);
                MagicMissile.boltFromChar(Dungeon.hero.sprite.parent, 100, Dungeon.hero.sprite, cone.coreRay.path.get(dist * 2 / 3), new Callback(){

                    @Override
                    public void call() {
                    }
                });
                Invisibility.dispel();
                Dungeon.hero.sprite.zap(cell);
                Dungeon.hero.busy();
                Dungeon.hero.spendAndNext(1.0f);
                MagicalCombo.this.detach();
            }
        }

        @Override
        public String prompt() {
            return Messages.get(MagicalCombo.class, "prompt", new Object[0]);
        }
    };

    @Override
    public int icon() {
        return 17;
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0.0f, (this.initialComboTime - this.comboTime) / this.initialComboTime);
    }

    @Override
    public void tintIcon(Image icon) {
        icon.hardlight(8978687);
    }

    @Override
    public String iconTextDisplay() {
        return Integer.toString((int)this.comboTime);
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    public void hit(Char enemy) {
        ++this.count;
        this.initialComboTime = this.comboTime = 5.0f;
        ActionIndicator.setAction(this);
        BuffIndicator.refreshHero();
        GLog.p(Messages.get(this, "combo", this.count), new Object[0]);
    }

    public void addTime(float time) {
        this.comboTime += time;
    }

    @Override
    public void detach() {
        super.detach();
        ActionIndicator.clearAction(this);
    }

    @Override
    public boolean act() {
        this.comboTime -= 1.0f;
        this.spend(1.0f);
        if (this.comboTime <= 0.0f) {
            this.detach();
        }
        if (!(Dungeon.hero.belongings.weapon instanceof MagesStaff)) {
            this.detach();
        }
        return true;
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.count, this.dispTurns(this.comboTime));
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(COUNT, this.count);
        bundle.put(TIME, this.comboTime);
        bundle.put(INITIAL_TIME, this.initialComboTime);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.count = bundle.getInt(COUNT);
        this.comboTime = bundle.getFloat(TIME);
        this.initialComboTime = bundle.getFloat(INITIAL_TIME);
        ActionIndicator.setAction(this);
    }

    @Override
    public String actionName() {
        return Messages.get(this, "action_name", new Object[0]);
    }

    @Override
    public int actionIcon() {
        return 112;
    }

    @Override
    public int indicatorColor() {
        return 0xFFFF00;
    }

    @Override
    public void doAction() {
        GameScene.show(new WndMagicalCombo(this));
    }

    public int getComboCount() {
        return this.count;
    }

    public boolean canUseMove(ComboMove move) {
        return move.talentReq <= Dungeon.hero.pointsInTalent(Talent.BATTLE_MAGIC);
    }

    public void useMove(ComboMove move) {
        if (move == ComboMove.EMMIT) {
            this.magicEmmit(Dungeon.hero);
        } else if (move == ComboMove.UNLEASH) {
            this.magicUnleash(Dungeon.hero);
            this.detach();
        } else if (move == ComboMove.POWER) {
            this.magicPower(Dungeon.hero);
            this.detach();
        } else {
            moveBeingUsed = move;
            GameScene.selectCell(this.listener);
        }
    }

    private void magicUnleash(final Hero hero) {
        Ballistica aim = hero.pos % Dungeon.level.width() > 10 ? new Ballistica(hero.pos, hero.pos - 1, 0) : new Ballistica(hero.pos, hero.pos + 1, 0);
        Class<? extends Wand> wandCls = null;
        if (hero.belongings.getItem(MagesStaff.class) != null) {
            wandCls = hero.belongings.getItem(MagesStaff.class).wandClass();
        }
        if (wandCls == null) {
            return;
        }
        final int aoeSize = 3 + this.count / 2;
        int projectileProps = 5;
        if (wandCls == WandOfDisintegration.class) {
            projectileProps = 1;
        } else if (wandCls == WandOfFireblast.class) {
            projectileProps |= 8;
        } else if (wandCls == WandOfWarding.class) {
            projectileProps = 1;
        }
        final ConeAOE aoe = new ConeAOE(aim, aoeSize, 360.0f, projectileProps);
        for (Ballistica ray : aoe.outerRays) {
            ((MagicMissile)hero.sprite.parent.recycle(MagicMissile.class)).reset((int)effectTypes.get(wandCls), (Visual)hero.sprite, (int)ray.path.get(ray.dist), null);
        }
        final float effectMulti = 0.1f * (float)this.count;
        final Class<? extends Wand> finalWandCls = wandCls;
        ((MagicMissile)hero.sprite.parent.recycle(MagicMissile.class)).reset((int)effectTypes.get(wandCls), (Visual)hero.sprite, (int)aim.path.get(aoeSize / 2), new Callback(){

            @Override
            public void call() {
                int charsHit = 0;
                Freezing freeze = (Freezing)Dungeon.level.blobs.get(Freezing.class);
                Fire fire = (Fire)Dungeon.level.blobs.get(Fire.class);
                Iterator<Object> iterator = aoe.cells.iterator();
                while (iterator.hasNext()) {
                    int cell = iterator.next();
                    if (finalWandCls == WandOfLightning.class) {
                        if (Dungeon.level.water[cell]) {
                            GameScene.add(Blob.seed(cell, 4, Electricity.class));
                        }
                    } else if (finalWandCls == WandOfFireblast.class) {
                        if (Dungeon.level.map[cell] == 5) {
                            Level.set(cell, 6);
                            GameScene.updateMap(cell);
                        }
                        if (freeze != null) {
                            freeze.clear(cell);
                        }
                        if (Dungeon.level.flamable[cell]) {
                            GameScene.add(Blob.seed(cell, 4, Fire.class));
                        }
                    } else if (finalWandCls == WandOfFrost.class) {
                        if (fire != null) {
                            fire.clear(cell);
                        }
                    } else if (finalWandCls == WandOfPrismaticLight.class) {
                        for (int n : PathFinder.NEIGHBOURS9) {
                            int terr;
                            int c = cell + n;
                            if (Dungeon.level.discoverable[c]) {
                                Dungeon.level.mapped[c] = true;
                            }
                            if ((Terrain.flags[terr = Dungeon.level.map[c]] & 8) == 0) continue;
                            Dungeon.level.discover(c);
                            GameScene.discoverTile(c, terr);
                            ScrollOfMagicMapping.discover(c);
                        }
                    } else if (finalWandCls == WandOfRegrowth.class) {
                        int t = Dungeon.level.map[cell];
                        if (Random.Float() < 0.33f * effectMulti && (t == 1 || t == 20 || t == 9 || t == 2 || t == 30) && Dungeon.level.plants.get(cell) == null) {
                            Level.set(cell, 15);
                            GameScene.updateMap(cell);
                        }
                    }
                    Char mob = Actor.findChar(cell);
                    int damage = Math.round((float)Random.NormalIntRange(15, 25) * effectMulti * ((Float)damageFactors.get(finalWandCls)).floatValue());
                    if (mob != null && damage > 0 && mob.alignment != Char.Alignment.ALLY) {
                        mob.damage(damage, Reflection.newInstance(finalWandCls));
                        ++charsHit;
                    }
                    if (mob == null || mob == hero) continue;
                    if (finalWandCls == WandOfLightning.class) {
                        if (!mob.isAlive() || mob.alignment == Char.Alignment.ALLY) continue;
                        Buff.affect(mob, Paralysis.class, effectMulti * 10.0f / 2.0f);
                        continue;
                    }
                    if (finalWandCls == WandOfFireblast.class) {
                        if (!mob.isAlive() || mob.alignment == Char.Alignment.ALLY) continue;
                        Buff.affect(mob, Burning.class).reignite(mob);
                        continue;
                    }
                    if (finalWandCls == WandOfCorrosion.class) {
                        if (!mob.isAlive() || mob.alignment == Char.Alignment.ALLY) continue;
                        Buff.affect(mob, Corrosion.class).set(4.0f, Math.round(6.0f * effectMulti));
                        ++charsHit;
                        continue;
                    }
                    if (finalWandCls == WandOfBlastWave.class) {
                        if (mob.alignment == Char.Alignment.ALLY) continue;
                        Ballistica aim = new Ballistica(hero.pos, mob.pos, 0);
                        int knockback = aoeSize + 1 - (int)Dungeon.level.trueDistance(hero.pos, mob.pos);
                        knockback = (int)((float)knockback * effectMulti);
                        WandOfBlastWave.throwChar(mob, new Ballistica(mob.pos, aim.collisionPos, 6), knockback, true, true, hero.getClass());
                        continue;
                    }
                    if (finalWandCls == WandOfFrost.class) {
                        if (!mob.isAlive() || mob.alignment == Char.Alignment.ALLY) continue;
                        Buff.affect(mob, Frost.class, effectMulti * 10.0f);
                        continue;
                    }
                    if (finalWandCls == WandOfPrismaticLight.class) {
                        if (!mob.isAlive() || mob.alignment == Char.Alignment.ALLY) continue;
                        Buff.prolong(mob, Blindness.class, effectMulti * 10.0f / 2.0f);
                        ++charsHit;
                        continue;
                    }
                    if (finalWandCls == WandOfWarding.class) {
                        if (!(mob instanceof WandOfWarding.Ward)) continue;
                        ((WandOfWarding.Ward)mob).wandHeal(0, effectMulti);
                        ++charsHit;
                        continue;
                    }
                    if (finalWandCls == WandOfTransfusion.class) {
                        if (mob.alignment == Char.Alignment.ALLY || mob.buff(Charm.class) != null) {
                            int healing = Math.round(10.0f * effectMulti);
                            int shielding = mob.HP + healing - mob.HT;
                            if (shielding > 0) {
                                healing -= shielding;
                                Buff.affect(mob, Barrier.class).setShield(shielding);
                            } else {
                                shielding = 0;
                            }
                            mob.HP += healing;
                            mob.sprite.emitter().burst(Speck.factory(0), 4);
                            mob.sprite.showStatus(65280, "+%dHP", healing + shielding);
                        } else if (!mob.properties().contains((Object)Char.Property.UNDEAD)) {
                            Charm charm = Buff.affect(mob, Charm.class, effectMulti * 10.0f / 2.0f);
                            charm.object = hero.id();
                            charm.ignoreHeroAllies = true;
                            mob.sprite.centerEmitter().start(Speck.factory(11), 0.2f, 3);
                        } else {
                            damage = Math.round((float)Random.NormalIntRange(15, 25) * effectMulti);
                            mob.damage(damage, Reflection.newInstance(finalWandCls));
                            mob.sprite.emitter().start(ShadowParticle.UP, 0.05f, 10);
                        }
                        ++charsHit;
                        continue;
                    }
                    if (finalWandCls == WandOfCorruption.class) {
                        if (!mob.isAlive() || mob.alignment == Char.Alignment.ALLY) continue;
                        Buff.prolong(mob, Amok.class, effectMulti * 5.0f);
                        ++charsHit;
                        continue;
                    }
                    if (finalWandCls != WandOfRegrowth.class || mob.alignment == Char.Alignment.ALLY) continue;
                    Buff.prolong(mob, Roots.class, effectMulti * 5.0f);
                    ++charsHit;
                }
                if (finalWandCls == WandOfMagicMissile.class) {
                    Buff.affect(hero, Recharging.class, effectMulti * 30.0f / 2.0f);
                } else if (finalWandCls == WandOfLivingEarth.class && charsHit > 0) {
                    for (Mob m : Dungeon.level.mobs) {
                        if (!(m instanceof WandOfLivingEarth.EarthGuardian)) continue;
                        ((WandOfLivingEarth.EarthGuardian)m).setInfo(hero, 0, Math.round(effectMulti * (float)charsHit * 5.0f));
                        m.sprite.centerEmitter().burst(MagicMissile.EarthParticle.ATTRACT, 8 + charsHit);
                        break;
                    }
                } else if (finalWandCls == WandOfFrost.class) {
                    if (hero.buff(Burning.class) != null) {
                        hero.buff(Burning.class).detach();
                    }
                } else if (finalWandCls == WandOfPrismaticLight.class) {
                    Buff.prolong(hero, Light.class, effectMulti * 50.0f);
                }
                hero.spendAndNext(1.0f);
            }
        });
        hero.sprite.operate(hero.pos);
        Invisibility.dispel();
        hero.busy();
        Sample.INSTANCE.play("sounds/chargeup.mp3");
    }

    private void magicEmmit(Hero hero) {
        GameScene.selectCell(this.magicEmmit);
    }

    private void magicPower(Hero hero) {
        MagesStaff staff = Dungeon.hero.belongings.getItem(MagesStaff.class);
        int duration = (staff.getCurCharges() + this.count) / 2;
        staff.loseCharge();
        Buff.prolong(hero, Adrenaline.class, duration);
        Buff.prolong(hero, Bless.class, duration);
        Sample.INSTANCE.play("sounds/chargeup.mp3");
        hero.sprite.operate(hero.pos);
        hero.busy();
        hero.spendAndNext(1.0f);
    }

    private void doAttack(Char enemy) {
        MagesStaff staff;
        AttackIndicator.target(enemy);
        boolean wasAlly = enemy.alignment == this.target.alignment;
        Hero hero = (Hero)this.target;
        float dmgMulti = 1.0f;
        boolean dmgBonus = false;
        switch (moveBeingUsed) {
            case BLAST: 
            case MANA_AMP: {
                dmgMulti = 0.6f;
                break;
            }
            case STAB: {
                dmgMulti = 0.2f * (float)this.count;
                break;
            }
        }
        if (hero.attack(enemy, dmgMulti, (float)dmgBonus, Char.INFINITE_ACCURACY)) {
            staff = Dungeon.hero.belongings.getItem(MagesStaff.class);
            switch (moveBeingUsed) {
                case BLAST: {
                    int dist;
                    Ballistica trajectory = new Ballistica(this.target.pos, enemy.pos, 1);
                    trajectory = new Ballistica(trajectory.collisionPos, trajectory.path.get(trajectory.path.size() - 1), 7);
                    if (!enemy.flying) {
                        for (dist = 1 + this.count / 2; dist > trajectory.dist || dist > 0 && Dungeon.level.pit[trajectory.path.get(dist)]; --dist) {
                        }
                    }
                    WandOfBlastWave.throwChar(enemy, trajectory, dist, true, false, hero.getClass());
                    break;
                }
                case STAB: {
                    hero.spend(-hero.attackDelay());
                    break;
                }
                case MANA_AMP: {
                    Buff.affect(hero, MagicalEmpower.class).set(hero.pointsInTalent(Talent.BATTLE_MAGIC), Math.min(1 + this.count / 2, staff.level()));
                    break;
                }
            }
        }
        Invisibility.dispel();
        switch (moveBeingUsed) {
            case EMMIT: {
                staff = Dungeon.hero.belongings.getItem(MagesStaff.class);
                this.detach();
                ActionIndicator.clearAction(this);
                break;
            }
            default: {
                hero.spendAndNext(hero.attackDelay());
                this.detach();
                ActionIndicator.clearAction(this);
            }
        }
    }

    static {
        effectTypes.put(WandOfMagicMissile.class, 100);
        effectTypes.put(WandOfLightning.class, 112);
        effectTypes.put(WandOfDisintegration.class, 111);
        effectTypes.put(WandOfFireblast.class, 102);
        effectTypes.put(WandOfCorrosion.class, 103);
        effectTypes.put(WandOfBlastWave.class, 105);
        effectTypes.put(WandOfLivingEarth.class, 109);
        effectTypes.put(WandOfFrost.class, 101);
        effectTypes.put(WandOfPrismaticLight.class, 108);
        effectTypes.put(WandOfWarding.class, 110);
        effectTypes.put(WandOfTransfusion.class, 113);
        effectTypes.put(WandOfCorruption.class, 107);
        effectTypes.put(WandOfRegrowth.class, 104);
        damageFactors = new HashMap();
        damageFactors.put(WandOfMagicMissile.class, Float.valueOf(0.5f));
        damageFactors.put(WandOfLightning.class, Float.valueOf(1.0f));
        damageFactors.put(WandOfDisintegration.class, Float.valueOf(1.0f));
        damageFactors.put(WandOfFireblast.class, Float.valueOf(1.0f));
        damageFactors.put(WandOfCorrosion.class, Float.valueOf(0.0f));
        damageFactors.put(WandOfBlastWave.class, Float.valueOf(0.67f));
        damageFactors.put(WandOfLivingEarth.class, Float.valueOf(0.5f));
        damageFactors.put(WandOfFrost.class, Float.valueOf(1.0f));
        damageFactors.put(WandOfPrismaticLight.class, Float.valueOf(0.67f));
        damageFactors.put(WandOfWarding.class, Float.valueOf(0.0f));
        damageFactors.put(WandOfTransfusion.class, Float.valueOf(0.0f));
        damageFactors.put(WandOfCorruption.class, Float.valueOf(0.0f));
        damageFactors.put(WandOfRegrowth.class, Float.valueOf(0.0f));
    }

    public static enum ComboMove {
        BLAST(1, -16711936),
        STAB(1, -16711936),
        MANA_AMP(2, -256),
        EMMIT(2, -256),
        UNLEASH(3, -65536),
        POWER(3, -65536);

        public int talentReq;
        public int tintColor;

        private ComboMove(int talentReq, int tintColor) {
            this.talentReq = talentReq;
            this.tintColor = tintColor;
        }

        public String desc(int count) {
            MagesStaff staff = Dungeon.hero.belongings.getItem(MagesStaff.class);
            switch (this) {
                default: {
                    return Messages.get((Object)this, this.name() + "_desc", new Object[0]);
                }
                case BLAST: {
                    return Messages.get((Object)this, this.name() + "_desc", 1 + count / 2);
                }
                case STAB: {
                    return Messages.get((Object)this, this.name() + "_desc", count * 10);
                }
                case MANA_AMP: {
                    return Messages.get((Object)this, this.name() + "_desc", Dungeon.hero.pointsInTalent(Talent.BATTLE_MAGIC), Math.min(1 + count / 2, staff.level()), staff.level());
                }
                case EMMIT: {
                    return Messages.get((Object)this, this.name() + "_desc", count);
                }
                case UNLEASH: {
                    return Messages.get((Object)this, this.name() + "_desc", count * 10, 3 + count / 2);
                }
                case POWER: 
            }
            return Messages.get((Object)this, this.name() + "_desc", (staff.getCurCharges() + count) / 2);
        }
    }
}

