/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.watabou.noosa.Image;
import com.watabou.utils.Bundle;

public class MagicalEmpower
extends Buff {
    private int initialLeft;
    private int left;
    public int upgrades;
    private static final String INITIALLEFT = "initialLeft";
    private static final String LEFT = "left";
    private static final String UPGRADES = "upgrades";

    public MagicalEmpower() {
        this.type = Buff.buffType.POSITIVE;
    }

    public void set(int duration, int amount) {
        this.left = this.initialLeft = duration;
        this.upgrades = amount;
        Item.updateQuickslot();
    }

    public void use() {
        --this.left;
        if (this.left <= 0) {
            this.detach();
        }
    }

    @Override
    public void detach() {
        super.detach();
        Item.updateQuickslot();
    }

    @Override
    public int icon() {
        return 50;
    }

    @Override
    public void tintIcon(Image icon) {
        icon.hardlight(1.0f, 1.0f, 0.0f);
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0, (this.initialLeft - this.left) / this.initialLeft);
    }

    @Override
    public String iconTextDisplay() {
        return Integer.toString(this.left);
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.upgrades, this.left);
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(INITIALLEFT, this.initialLeft);
        bundle.put(LEFT, this.left);
        bundle.put(UPGRADES, this.upgrades);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.initialLeft = bundle.getInt(INITIALLEFT);
        this.left = bundle.getInt(LEFT);
        this.upgrades = bundle.getInt(UPGRADES);
    }
}

