/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.LockedFloor;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Regeneration;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.PrismaticImage;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfTeleportation;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.watabou.noosa.Image;
import com.watabou.utils.Bundle;
import com.watabou.utils.PathFinder;

public class PrismaticGuard
extends Buff {
    private float HP;
    private static final String HEALTH = "hp";

    public PrismaticGuard() {
        this.type = Buff.buffType.POSITIVE;
    }

    @Override
    public boolean act() {
        Hero hero = (Hero)this.target;
        Mob closest = null;
        int v = hero.visibleEnemies();
        for (int i = 0; i < v; ++i) {
            Mob mob = hero.visibleEnemy(i);
            if (!mob.isAlive() || mob.state == mob.PASSIVE || mob.state == mob.WANDERING || mob.state == mob.SLEEPING || hero.mindVisionEnemies.contains(mob) || closest != null && Dungeon.level.distance(hero.pos, mob.pos) >= Dungeon.level.distance(hero.pos, closest.pos)) continue;
            closest = mob;
        }
        if (closest != null && Dungeon.level.distance(hero.pos, closest.pos) < 5) {
            int bestPos = -1;
            for (int i = 0; i < PathFinder.NEIGHBOURS8.length; ++i) {
                int p = hero.pos + PathFinder.NEIGHBOURS8[i];
                if (Actor.findChar(p) != null || !Dungeon.level.passable[p] || bestPos != -1 && !(Dungeon.level.trueDistance(p, closest.pos) < Dungeon.level.trueDistance(bestPos, closest.pos))) continue;
                bestPos = p;
            }
            if (bestPos != -1) {
                PrismaticImage pris = new PrismaticImage();
                pris.duplicate(hero, (int)Math.floor(this.HP));
                pris.state = pris.HUNTING;
                GameScene.add(pris, 1.0f);
                ScrollOfTeleportation.appear(pris, bestPos);
                this.detach();
            } else {
                this.spend(1.0f);
            }
        } else {
            this.spend(1.0f);
        }
        LockedFloor lock = this.target.buff(LockedFloor.class);
        if (this.HP < (float)this.maxHP() && Regeneration.regenOn()) {
            this.HP += 0.1f;
        }
        return true;
    }

    public void set(int HP) {
        this.HP = HP;
    }

    public void extend(int HP) {
        this.HP = this.HP + (float)HP < (float)this.maxHP() ? (this.HP += (float)HP) : (float)this.maxHP();
    }

    public int HP() {
        return Math.round(this.HP);
    }

    public int maxHP() {
        return PrismaticGuard.maxHP((Hero)this.target);
    }

    public static int maxHP(Hero hero) {
        return 10 + (int)Math.floor((float)hero.lvl * 2.5f);
    }

    @Override
    public int icon() {
        return 20;
    }

    @Override
    public void tintIcon(Image icon) {
        icon.hardlight(1.0f, 1.0f, 2.0f);
    }

    @Override
    public float iconFadePercent() {
        return 1.0f - this.HP / (float)this.maxHP();
    }

    @Override
    public String iconTextDisplay() {
        return Integer.toString((int)this.HP);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", (int)this.HP, this.maxHP());
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(HEALTH, this.HP);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.HP = bundle.getFloat(HEALTH);
    }
}

