/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;
import com.watabou.noosa.Image;
import com.watabou.utils.Bundle;

public class SerialAttack
extends Buff {
    private int count = 0;
    private int dmgBonus = 0;
    private float comboTime = 0.0f;
    private float initialComboTime = 5.0f;
    private static final String COUNT = "count";
    private static final String TIME = "combotime";
    private static final String INITIAL_TIME = "initialComboTime";

    @Override
    public int icon() {
        return 45;
    }

    @Override
    public void tintIcon(Image icon) {
        icon.hardlight(1.0f, 0.0f, 0.0f);
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0.0f, (this.initialComboTime - this.comboTime) / this.initialComboTime);
    }

    public int getCount() {
        return this.count;
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    public void maxHit() {
        this.count = 4 + Dungeon.hero.pointsInTalent(Talent.CONTINUOUS_ATTACK);
        this.dmgBonus = 5 * (4 + Dungeon.hero.pointsInTalent(Talent.CONTINUOUS_ATTACK));
        this.comboTime = 5.0f;
        if (Dungeon.hero.hasTalent(Talent.SERIAL_MOMENTUM)) {
            this.comboTime += (float)Dungeon.hero.pointsInTalent(Talent.SERIAL_MOMENTUM);
        }
        this.initialComboTime = this.comboTime;
        BuffIndicator.refreshHero();
    }

    public void hit(Char enemy) {
        if (this.count < 4 + Dungeon.hero.pointsInTalent(Talent.CONTINUOUS_ATTACK)) {
            ++this.count;
            this.dmgBonus += 5;
        } else {
            this.count = 4 + Dungeon.hero.pointsInTalent(Talent.CONTINUOUS_ATTACK);
            this.dmgBonus = 5 * (4 + Dungeon.hero.pointsInTalent(Talent.CONTINUOUS_ATTACK));
        }
        this.comboTime = 5.0f;
        if (Dungeon.hero.hasTalent(Talent.SERIAL_MOMENTUM)) {
            this.comboTime += (float)Dungeon.hero.pointsInTalent(Talent.SERIAL_MOMENTUM);
        }
        this.initialComboTime = this.comboTime;
        BuffIndicator.refreshHero();
    }

    public void addTime(float time) {
        this.comboTime += time;
    }

    @Override
    public void detach() {
        super.detach();
    }

    @Override
    public boolean act() {
        this.comboTime -= 1.0f;
        this.spend(1.0f);
        if (this.comboTime <= 0.0f) {
            this.detach();
        }
        return true;
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.count, this.dmgBonus, this.dispTurns(this.comboTime));
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(COUNT, this.count);
        bundle.put(TIME, this.comboTime);
        bundle.put(INITIAL_TIME, this.initialComboTime);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.count = bundle.getInt(COUNT);
        this.comboTime = bundle.getFloat(TIME);
        this.initialComboTime = bundle.getFloat(INITIAL_TIME);
    }
}

