/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.watabou.noosa.Image;
import com.watabou.utils.Bundle;

public class SpellBookCoolDown
extends Buff {
    int duration;
    int maxDuration;
    private static final String MAX_DURATION = "maxDuration";
    private static final String DURATION = "duration";

    public SpellBookCoolDown() {
        this.type = Buff.buffType.NEUTRAL;
        this.announced = false;
    }

    public void set(int time) {
        this.duration = this.maxDuration = time;
    }

    public void use(int time) {
        this.duration -= time;
        if (this.duration <= 0) {
            this.detach();
        }
    }

    @Override
    public boolean act() {
        --this.duration;
        if (this.duration <= 0) {
            this.detach();
        }
        this.spend(1.0f);
        return true;
    }

    @Override
    public int icon() {
        return 7;
    }

    @Override
    public void tintIcon(Image icon) {
        icon.hardlight(13934671);
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0, (this.maxDuration - this.duration) / this.maxDuration);
    }

    @Override
    public String iconTextDisplay() {
        return Integer.toString(this.duration);
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.duration);
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(MAX_DURATION, this.maxDuration);
        bundle.put(DURATION, this.duration);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.maxDuration = bundle.getInt(MAX_DURATION);
        this.duration = bundle.getInt(DURATION);
    }
}

