/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.SurgeryUse;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;
import com.watabou.utils.Bundle;

public class Surgery
extends Buff {
    private int count = 0;
    private static final String COUNT = "count";

    @Override
    public int icon() {
        return 27;
    }

    public int getCount() {
        return this.count;
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    public void hit() {
        ++this.count;
        if (Dungeon.hero.hasTalent(Talent.DEATH_DIAGNOSIS) && this.count >= 18 - 3 * Dungeon.hero.pointsInTalent(Talent.DEATH_DIAGNOSIS)) {
            Buff.affect(this.target, SurgeryUse.class);
        }
        BuffIndicator.refreshHero();
    }

    @Override
    public boolean act() {
        this.spend(1.0f);
        return true;
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.count * 2);
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(COUNT, this.count);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.count = bundle.getInt(COUNT);
    }
}

